/* File: startup_ARMCM33.S
 * Purpose: startup file for Cortex-M0 devices. Should use with
 *   GCC for ARM Embedded Processors
 * Version: V2.0
 * Date: 16 August 2013
 *
 * Copyright (c) 2011 - 2013 ARM LIMITED

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/
    .syntax     unified
    .arch       armv8-m.base

    .section .stack
    .align      3
    .equ        Stack_Size, 0xc00
    .globl      __StackTop
    .globl      __StackLimit
__StackLimit:
    .space      Stack_Size
    .size       __StackLimit, . - __StackLimit
__StackTop:
    .size       __StackTop, . - __StackTop

    .section    .heap
    .align      3
    .equ        Heap_Size, 0

    .globl      __HeapBase
    .globl      __HeapLimit
__HeapBase:
    .if         Heap_Size
    .space      Heap_Size
    .endif
    .size       __HeapBase, . - __HeapBase
__HeapLimit:
    .size       __HeapLimit, . - __HeapLimit

    .section    .isr_vector
    .align 2
    .globl      __isr_vector
__isr_vector:
    .long       __StackTop                      /* Top of Stack */
    .long       Reset_Handler                   /* Reset Handler */
    .long       NMI_Handler                     /* NMI Handler */
    .long       HardFault_Handler               /* Hard Fault Handler */
    .long       MemManage_Handler               /* MPU Fault Handler */
    .long       BusFault_Handler                /* Bus Fault Handler */
    .long       UsageFault_Handler              /* Usage Fault Handler */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       SVC_Handler                     /* SVCall Handler,SWI */
    .long       DebugMon_Handler                /* Debug Monitor Handler */
    .long       0                               /* Reserved */
    .long       PendSV_Handler                  /* PendSV Handler */
    .long       SysTick_Handler                 /* SysTick Handler */

    /* External interrupts */
    .long       WDT_IRQHandler                /* 0:  WDT_IRQHandler  */
    .long       LVD_IRQHandler                /* 1:  LVD_IRQHandler  */
    .long       RTC_IRQHandler                /* 2:  RTC_IRQHandler  */
    .long       RSV1_IRQHandler               /* 3:                  */
    .long       EFC_IRQHandler                /* 4:  EFC_IRQHandler  */
    .long       SRAM_PARITY_IRQHandler        /* 5:  SRAM_PARITY_IRQHandler*/
    .long       CLKRDY_IRQHandler             /* 6:  CLKRDY_IRQHandler  */
    .long       EXTI0_IRQHandler              /* 7:  EXTI0_IRQHandler   */
    .long       EXTI1_IRQHandler              /* 8:  EXTI1_IRQHandler   */
    .long       EXTI2_IRQHandler              /* 9:  EXTI2_IRQHandler   */
    .long       EXTI3_IRQHandler              /* 10: EXTI3_IRQHandler   */
    .long       EXTI4_IRQHandler              /* 11: EXTI4_IRQHandler   */
    .long       DMA1_IRQHandler               /* 12: DMA1_IRQHandler    */
    .long       DMA2_IRQHandler               /* 13: DMA2_IRQHandler    */
    .long       ADC1_2_IRQHandler             /* 14: ADC1_2_IRQHandler  */
    .long       RSV2_IRQHandler               /* 15:                    */
    .long       DAC_IRQHandler                /* 16: DAC_IRQHandler     */
    .long       COMP1_2_IRQHandler            /* 17: COMP1_2_IRQHandler */
    .long       USB_IRQHandler                /* 18: USB_IRQHandler     */
    .long       CAN1_IRQHandler               /* 19: CAN1_IRQHandler    */
    .long       CAN2_IRQHandler               /* 20: CAN2_IRQHandler    */
    .long       EXTI9_5_IRQHandler            /* 21: EXTI9_5_IRQHandler    */
    .long       TIM1_BRK_UP_TRG_COM_IRQHandler  /* 22: TIM1_BRK_UP_TRG_COM_IRQHandler  */
    .long       TIM1_CC_IRQHandler            /* 23: TIM1_CC_IRQHandler */
    .long       TIM2_IRQHandler               /* 24: TIM2_IRQHandler    */
    .long       TIM3_IRQHandler               /* 25: TIM3_IRQHandler    */
    .long       TIM6_IRQHandler               /* 26: TIM6_IRQHandler    */
    .long       TIM7_IRQHandler               /* 27: TIM7_IRQHandler    */
    .long       TIM8_BRK_UP_TRG_COM_IRQHandler  /* 28: TIM8_BRK_UP_TRG_COM_IRQHandler  */
    .long       TIM8_CC_IRQHandler            /* 29: TIM8_CC_IRQHandler */
    .long       TIM15_IRQHandler              /* 30: TIM15_IRQHandler   */
    .long       TIM16_IRQHandler              /* 31: TIM16_IRQHandler   */
    .long       TIM17_IRQHandler              /* 32: TIM17_IRQHandler   */
    .long       I2C1_IRQHandler               /* 33: I2C1_IRQHandler    */
    .long       I2C2_IRQHandler               /* 34: I2C2_IRQHandler    */
    .long       SPI1_IRQHandler               /* 35: SPI1_IRQHandler    */
    .long       SPI2_IRQHandler               /* 36: SPI2_IRQHandler    */
    .long       SPI3_IRQHandler               /* 37: SPI3_IRQHandler    */
    .long       I2S1_IRQHandler               /* 38: I2S1_IRQHandler    */
    .long       I2S2_IRQHandler               /* 39: I2S2_IRQHandler    */
    .long       UART1_IRQHandler              /* 40: UART1_IRQHandler   */
    .long       UART2_IRQHandler              /* 41: UART2_IRQHandler   */
    .long       UART3_IRQHandler              /* 42: UART3_IRQHandler   */
    .long       UART4_IRQHandler              /* 43: UART4_IRQHandler   */
    .long       EXTI15_10_IRQHandler          /* 44: EXTI15_10_IRQhandler   */
    .long       USB_WAKEUP_IRQHandler         /* 45: USB_WAKEUP_IRQHandler  */
    .long       LPUART1_IRQHandler            /* 46: LPUART1_IRQHandle  r*/
    .long       LPTIM1_IRQHandler             /* 47: LPTIM1_IRQHandler  */
    .long       RSV3_IRQHandler               /* 48:                    */
    .long       AES_IRQHandler                /* 49: AES_IRQHandler     */
    .long       FPU_IRQHandler                /* 50: FPU_IRQHandler     */
    .long       RSV4_IRQHandler               /* 51: */
    .long       STOP_RESET_IRQHandler         /* 52: STOP_RESET_IRQHandler*/
    .long       TIM4_IRQHandler               /* 53: TIM4_IRQHandler*/
    .long       COMP3_4_IRQHandler            /* 54: COMP3_4_IRQHandler*/
    .long       IWDT_WAKEUP_IRQHandler        /* 55: IWDT_WAKEUP_IRQHandler*/


    .size       __isr_vector, . - __isr_vector

    .text
    .thumb
    .thumb_func
    .align    1
    .globl      Reset_Handler
    .type       Reset_Handler, %function
Reset_Handler:
    ldr    r1, =__etext
    ldr    r2, =__data_start__
    ldr    r3, =__data_end__

    subs    r3, r2
    ble    .L_loop1_done

.L_loop1:
    subs   r3, #4
    ldr    r0, [r1,r3]
    str    r0, [r2,r3]
    bgt    .L_loop1

.L_loop1_done:
    ldr    r1, =__bss_start__
    ldr    r2, =__bss_end__

    movs   r0, 0

    subs   r2, r1
    ble    .L_loop3_done

.L_loop3:
    subs   r2, #4
    str    r0, [r1, r2]
    bgt    .L_loop3
.L_loop3_done:
    bl     SystemInit
    bl     _start

    .pool
    .size    Reset_Handler, . - Reset_Handler

    .align    1
    .thumb_func
    .weak    Default_Handler
    .type    Default_Handler, %function
Default_Handler:
    b    .
    .size    Default_Handler, . - Default_Handler

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
    .macro    def_irq_handler    handler_name
    .weak    \handler_name
    .set    \handler_name, Default_Handler
    .endm

    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    MemManage_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler       WDT_IRQHandler                /* 0:  WDT_IRQHandler  */
    def_irq_handler       LVD_IRQHandler                /* 1:  LVD_IRQHandler  */
    def_irq_handler       RTC_IRQHandler                /* 2:  RTC_IRQHandler  */
    def_irq_handler       RSV1_IRQHandler               /* 3:                  */
    def_irq_handler       EFC_IRQHandler                /* 4:  EFC_IRQHandler  */
    def_irq_handler       SRAM_PARITY_IRQHandler        /* 5:  SRAM_PARITY_IRQHandler*/
    def_irq_handler       CLKRDY_IRQHandler             /* 6:  CLKRDY_IRQHandler  */
    def_irq_handler       EXTI0_IRQHandler              /* 7:  EXTI0_IRQHandler   */
    def_irq_handler       EXTI1_IRQHandler              /* 8:  EXTI1_IRQHandler   */
    def_irq_handler       EXTI2_IRQHandler              /* 9:  EXTI2_IRQHandler   */
    def_irq_handler       EXTI3_IRQHandler              /* 10: EXTI3_IRQHandler   */
    def_irq_handler       EXTI4_IRQHandler              /* 11: EXTI4_IRQHandler   */
    def_irq_handler       DMA1_IRQHandler               /* 12: DMA1_IRQHandler    */
    def_irq_handler       DMA2_IRQHandler               /* 13: DMA2_IRQHandler    */
    def_irq_handler       ADC1_2_IRQHandler             /* 14: ADC1_2_IRQHandler  */
    def_irq_handler       RSV2_IRQHandler               /* 15:                    */
    def_irq_handler       DAC_IRQHandler                /* 16: DAC_IRQHandler     */
    def_irq_handler       COMP1_2_IRQHandler            /* 17: COMP1_2_IRQHandler */
    def_irq_handler       USB_IRQHandler                /* 18: USB_IRQHandler     */
    def_irq_handler       CAN1_IRQHandler               /* 19: CAN1_IRQHandler    */
    def_irq_handler       CAN2_IRQHandler               /* 20: CAN2_IRQHandler    */
    def_irq_handler       EXTI9_5_IRQHandler            /* 21: EXTI9_5_IRQHandler    */
    def_irq_handler       TIM1_BRK_UP_TRG_COM_IRQHandler  /* 22: TIM1_BRK_UP_TRG_COM_IRQHandler  */
    def_irq_handler       TIM1_CC_IRQHandler            /* 23: TIM1_CC_IRQHandler */
    def_irq_handler       TIM2_IRQHandler               /* 24: TIM2_IRQHandler    */
    def_irq_handler       TIM3_IRQHandler               /* 25: TIM3_IRQHandler    */
    def_irq_handler       TIM6_IRQHandler               /* 26: TIM6_IRQHandler    */
    def_irq_handler       TIM7_IRQHandler               /* 27: TIM7_IRQHandler    */
    def_irq_handler       TIM8_BRK_UP_TRG_COM_IRQHandler  /* 28: TIM8_BRK_UP_TRG_COM_IRQHandler  */
    def_irq_handler       TIM8_CC_IRQHandler            /* 29: TIM8_CC_IRQHandler */
    def_irq_handler       TIM15_IRQHandler              /* 30: TIM15_IRQHandler   */
    def_irq_handler       TIM16_IRQHandler              /* 31: TIM16_IRQHandler   */
    def_irq_handler       TIM17_IRQHandler              /* 32: TIM17_IRQHandler   */
    def_irq_handler       I2C1_IRQHandler               /* 33: I2C1_IRQHandler    */
    def_irq_handler       I2C2_IRQHandler               /* 34: I2C2_IRQHandler    */
    def_irq_handler       SPI1_IRQHandler               /* 35: SPI1_IRQHandler    */
    def_irq_handler       SPI2_IRQHandler               /* 36: SPI2_IRQHandler    */
    def_irq_handler       SPI3_IRQHandler               /* 37: SPI3_IRQHandler    */
    def_irq_handler       I2S1_IRQHandler               /* 38: I2S1_IRQHandler    */
    def_irq_handler       I2S2_IRQHandler               /* 39: I2S2_IRQHandler    */
    def_irq_handler       UART1_IRQHandler              /* 40: UART1_IRQHandler   */
    def_irq_handler       UART2_IRQHandler              /* 41: UART2_IRQHandler   */
    def_irq_handler       UART3_IRQHandler              /* 42: UART3_IRQHandler   */
    def_irq_handler       UART4_IRQHandler              /* 43: UART4_IRQHandler   */
    def_irq_handler       EXTI15_10_IRQHandler          /* 44: EXTI15_10_IRQhandler   */  
    def_irq_handler       USB_WAKEUP_IRQHandler         /* 45: USB_WAKEUP_IRQHandler  */
    def_irq_handler       LPUART1_IRQHandler            /* 46: LPUART1_IRQHandle  r*/
    def_irq_handler       LPTIM1_IRQHandler             /* 47: LPTIM1_IRQHandler  */  
    def_irq_handler       RSV3_IRQHandler               /* 48:                    */
    def_irq_handler       AES_IRQHandler                /* 49: AES_IRQHandler     */
    def_irq_handler       FPU_IRQHandler                /* 50: FPU_IRQHandler     */
    def_irq_handler       RSV4_IRQHandler               /* 51: */
    def_irq_handler       STOP_RESET_IRQHandler         /* 52: STOP_RESET_IRQHandler*/
    def_irq_handler       TIM4_IRQHandler               /* 53: TIM4_IRQHandler*/
    def_irq_handler       COMP3_4_IRQHandler            /* 54: COMP3_4_IRQHandler*/
    def_irq_handler       IWDT_WAKEUP_IRQHandler        /* 55: IWDT_WAKEUP_IRQHandler*/                                                                       
    .end
