
/******************************************************************************
*@file  : hal_opa.h
*@brief : OPA HAL module driver header file.
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#ifndef __HAL_OPA_H__
#define __HAL_OPA_H__

#include "acm32g103_hal_conf.h"


#define OPA1        (0x01)
#define OPA2        (0x02)
#define OPA3        (0x03)

typedef struct
{
    uint8_t             OPAx;       // witch opa be selected
    uint32_t            Mode;       // the opa work mode select 
    uint32_t            VinPSel;    // the opa VINP vin p select    
    uint32_t            VinM0En;    // the opa VinM0 enable 
    uint32_t            OutSel;     // the opa output select    
    uint32_t            PolSel;     // the opa Polarity select    
    uint32_t            Hsm;        // the opa HSM driver mode:OPA_HSM_LOW or OPA_HSM_HIGH
    uint32_t            Gain;       // the opa gain select   
    uint32_t            TrimEn;     // if the opa auto trim    
}OPA_InitTypeDef;


typedef struct
{
    OPA_TypeDef         *Instance;  // Register base address
    OPA_InitTypeDef     Init;       // OPA required parameters
} OPA_HandleTypeDef;


#define OPA_HSM_LOW                         (0UL)
#define OPA_HSM_HIGH                        (OPA_CSR_HSM)

#define OPA_GAIN_64_63                      (0u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_32_31                      (1u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_16_15                      (2u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_8_7                        (4u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_4_3                        (8u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_2_1                        (16u << OPA_CSR_GAINSEL_Pos)

#define OPA_POL_NOINVERT                    (0u)
#define OPA_POL_INVERT                      (0x1UL << OPA_CSR_POLSEL_Pos)

#define OPA_VINM0_DISABLE                   (0u)
#define OPA_VINM0_ENABLE                    (OPA_CSR_VINM0EN)

#define OPA_MODE_SA                         (0u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_UG                         (1u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_PGA                        (2u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_SA1                        (3u << OPA_CSR_MODESEL_Pos)

#define OPA_VINP_0                          (0u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_1                          (1u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_2                          (2u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_3                          (3u << OPA_CSR_VINPSEL_Pos)

#define OPA1_VINP_PA1                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_PA3                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_PA7                       (2u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_DAC1                      (3u << OPA_CSR_VINPSEL_Pos)

#define OPA2_VINP_PA7                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_PB0                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_OPA1                      (2u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_DAC2                      (3u << OPA_CSR_VINPSEL_Pos)

#define OPA3_VINP_PB0                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_PA1                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_PB11                      (2u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_DAC1                      (3u << OPA_CSR_VINPSEL_Pos)

#define OPA_OUT_GPIO                        (0u)
#define OPA_OUT_INNER                       (0x1UL << OPA_CSR_OUTSEL_Pos)

#define OPA_TRIM_DISABLE                    (0U)
#define OPA_TRIM_ENABLE                     (1U)



#define IS_OPA_INSTANCE(_INSTANCE_)         (((_INSTANCE_) == OPA))

#define IS_OPA_OPAx(_OPAx_)                 (((_OPAx_) == OPA1) || \
                                             ((_OPAx_) == OPA2) || \
                                             ((_OPAx_) == OPA3))

#define IS_OPA_HSM(_HSM_)                   (((_HSM_) == OPA_HSM_LOW) || \
                                             ((_HSM_) == OPA_HSM_HIGH))
                                        
#define IS_OPA_GAIN(_GAIN_)                 (((_GAIN_) == OPA_GAIN_64_63) || \
                                             ((_GAIN_) == OPA_GAIN_32_31) || \
                                             ((_GAIN_) == OPA_GAIN_16_15) || \
                                             ((_GAIN_) == OPA_GAIN_8_7) || \
                                             ((_GAIN_) == OPA_GAIN_4_3) || \
                                             ((_GAIN_) == OPA_GAIN_2_1))

#define IS_OPA_POL(_POL_)                   (((_POL_) == OPA_POL_NOINVERT) || \
                                             ((_POL_) == OPA_POL_INVERT))

#define IS_OPA_VINM0(_VINM0_)               (((_VINM0_) == OPA_VINM0_DISABLE) || \
                                             ((_VINM0_) == OPA_VINM0_ENABLE))
                                        
#define IS_OPA_MODE(_MODE_)                 (((_MODE_) == OPA_MODE_SA) || \
                                             ((_MODE_) == OPA_MODE_UG) || \
                                             ((_MODE_) == OPA_MODE_PGA) || \
                                             ((_MODE_) == OPA_MODE_SA1))
                                        
#define IS_OPA_VINP(_VINP_)                 (((_VINP_) == OPA_VINP_0) || \
                                             ((_VINP_) == OPA_VINP_1) || \
                                             ((_VINP_) == OPA_VINP_2) || \
                                             ((_VINP_) == OPA_VINP_3))
                                        
#define IS_OPA_OUT(_OUT_)                   (((_OUT_) == OPA_OUT_GPIO) || \
                                             ((_OUT_) == OPA_OUT_INNER))

#define IS_OPA_TRIM(_TRIM_)                 (((_TRIM_) == OPA_TRIM_DISABLE) || \
                                             ((_TRIM_) == OPA_TRIM_ENABLE))


void HAL_OPA_MspInit(OPA_HandleTypeDef* hopa);
void HAL_OPA_MspDeInit(OPA_HandleTypeDef* hopa);
HAL_StatusTypeDef HAL_OPA_Init(OPA_HandleTypeDef* hopa);
HAL_StatusTypeDef HAL_OPA_DeInit(OPA_HandleTypeDef* hopa);
HAL_StatusTypeDef HAL_OPA_Enable(OPA_HandleTypeDef* hopa);
HAL_StatusTypeDef HAL_OPA_Disable(OPA_HandleTypeDef* hopa);
HAL_StatusTypeDef HAL_OPA_Lock(OPA_HandleTypeDef* hopa);

#endif





