
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   


#define BUFFER_LENGTH    (21)
uint32_t gadcBuffer[BUFFER_LENGTH];                 //ADC Value
__IO uint32_t gadcxConvertedRegValue;               //ADC value obtained in interrupt      
static volatile uint32_t gadc1ItcCount = 0;        // transfer complete interrupt count



ADC_HandleTypeDef DualADC1_Handle;
ADC_HandleTypeDef DualADC2_Handle;
DMA_HandleTypeDef DUAL_ADC1_DMAHandle;



/******************************************************************************
* @brief : ADC Get The VrefP Value.
* @param : none
* @return: VrefP Value
******************************************************************************/ 
uint32_t ADC_GetVrefP(void)
{
    ADC_HandleTypeDef ADC_Handle_Vrefp;
    ADC_ChannelConfTypeDef ADC_ChannelConf;
    uint32_t TrimValue_3v, AdcValue_VrefP[1], VrefP,temp;
    
    //PMU CLK Enable
    RCC->APB1ENR |= 1<<27;
    //VBG1P2
    *(__IO uint32_t*)(0x400070C0) = 0x05;
    
    HAL_SimpleDelay(2000);
    
    ADC_Handle_Vrefp.Init.ClockPrescaler = ADC_CLOCK_DIV16;       //ADC_CLKƵѡ
    ADC_Handle_Vrefp.Init.Resolution     = ADC_RESOLUTION_12B;    //ֱ
    ADC_Handle_Vrefp.Init.DataAlign      = ADC_DATAALIGN_RIGHT;   //ݶ
    ADC_Handle_Vrefp.Init.ConConvMode    = DISABLE;               //תģʽ

    ADC_Handle_Vrefp.Init.DiscontinuousConvMode = DISABLE;        //ģʽ
    ADC_Handle_Vrefp.Init.NbrOfDiscConversion = 1;                //ģʽͨ
    ADC_Handle_Vrefp.Init.ExternalTrigConv = ADC_SOFTWARE_START;  //ģʽⲿ
    ADC_Handle_Vrefp.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;//ⲿѡ
    ADC_Handle_Vrefp.Init.DMAMode = ADC_DMAMODE_DISABLE;          //DMAѡ
    ADC_Handle_Vrefp.Init.OverMode = ADC_OVERMODE_DISABLE;        //ʱǷϴβ

    ADC_Handle_Vrefp.Init.OverSampMode = ADC_OVERSAMPMODE_DISABLE;//ʹ
    ADC_Handle_Vrefp.Init.Oversampling.Ratio =ADC_OVERSAMPLING_RATIO_2;//
    ADC_Handle_Vrefp.Init.Oversampling.RightBitShift =ADC_RIGHTBITSHIFT_2;//λϵ
    ADC_Handle_Vrefp.Init.Oversampling.TriggeredMode =0;          //ģʽ    
    ADC_Handle_Vrefp.Init.AnalogWDGEn = ADC_ANALOGWDGEN_DISABLE;  //ģ⿴Ź
    ADC_Handle_Vrefp.Init.ChannelEn = ADC_CHANNEL_VBGR_EN;

    ADC_Handle_Vrefp.Instance = ADC1;  

    HAL_ADC_Init(&ADC_Handle_Vrefp);

    /* The total adc regular channels number */
    ADC_Handle_Vrefp.ChannelNum = 1;
    
    /* Add adc channels */
    ADC_ChannelConf.Channel = ADC_CHANNEL_VBGR;
    ADC_ChannelConf.Sq = ADC_SEQUENCE_SQ1;
    ADC_ChannelConf.Smp = ADC_SMP_CLOCK_320;
    ADC_ChannelConf.SingleDiff = ADC_SINGLE_ENDED;
    ADC_ChannelConf.OffsetNumber = ADC_OFFSET_NONE;
    ADC_ChannelConf.Offset = 0;	
    HAL_ADC_ConfigChannel(&ADC_Handle_Vrefp,&ADC_ChannelConf);
    
    HAL_ADC_Polling(&ADC_Handle_Vrefp, AdcValue_VrefP, ADC_Handle_Vrefp.ChannelNum, 0);
    
    printfS("The adc convert result :  0x%08x[ %d ], VBGR = %dmV\r\n", AdcValue_VrefP[0], AdcValue_VrefP[0] & 0xFFF, ((AdcValue_VrefP[0] & 0xFFF) * 3300 / 4095));
    
    //VBG1P2
    *(__IO uint32_t*)(0x400070C0) &= ~0x05;
    
    TrimValue_3v = *(volatile uint32_t*)(0x00080240); //Read the 1.2v trim value in 3.0v vrefp.

    printfS("The adc 1.2v trim value is : 0x%08x \r\n", TrimValue_3v);

    if(((~TrimValue_3v&0xFFFF0000)>>16) == (TrimValue_3v&0x0000FFFF))
    {
        temp = TrimValue_3v & 0xFFF;
        
        VrefP = (uint32_t)(temp * 3000 / (AdcValue_VrefP[0] & 0xFFF));
      
        return VrefP;
    }
    return 0;
}



/******************************************************************************
* @brief : DMA adc to memory transfer complete interrupt Callback.
* @param : hdma: pointer to a DMA_HandleTypeDef structure that contains
*                 the configuration information for DMA module.
* @return: none
******************************************************************************/ 
void DMA_ADC1_ITC_Callback(DMA_HandleTypeDef *hdma)
{    
    gadc1ItcCount = 1;
}

/******************************************************************************
* @brief : Dual ADC RegSimult Test.
* @param : none
* @return: none
******************************************************************************/ 
void Dual_ADC_RegSimult_Test(void)
{
    uint32_t i, VrefP, Voltage;
    ADC_ChannelConfTypeDef ADC_RegChannelConf;
    ADC_MultiModeTypeDef   Multimode;
    ADC_InjectionConfTypeDef sConfigInjected;
    
    VrefP = ADC_GetVrefP();
    printfS("The VrefP value is : %d \r\n", VrefP);

    /* ADC1 */
    DualADC1_Handle.Init.ClockPrescaler = ADC_CLOCK_DIV16;
    DualADC1_Handle.Init.Resolution     = ADC_RESOLUTION_12B;  
    DualADC1_Handle.Init.DataAlign      = ADC_DATAALIGN_RIGHT;  
    DualADC1_Handle.Init.ConConvMode    = DISABLE;
    DualADC1_Handle.Init.DiscontinuousConvMode = DISABLE;

    DualADC1_Handle.Init.ExternalTrigConv =  ADC_SOFTWARE_START;  
    DualADC1_Handle.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;   

    DualADC1_Handle.Init.DMAMode = ADC_DMAMODE_DISABLE;
    DualADC1_Handle.Init.OverMode = ADC_OVERMODE_DISABLE;
    //Oversampling mode
    DualADC1_Handle.Init.OverSampMode = ADC_OVERSAMPMODE_DISABLE;
    DualADC1_Handle.Init.Oversampling.Ratio =ADC_OVERSAMPLING_RATIO_2;
    DualADC1_Handle.Init.Oversampling.RightBitShift =ADC_RIGHTBITSHIFT_2;
    DualADC1_Handle.Init.Oversampling.TriggeredMode =0;
    DualADC1_Handle.Init.AnalogWDGEn = ADC_ANALOGWDGEN_DISABLE;
    DualADC1_Handle.Init.ChannelEn = ADC_CHANNEL_1_EN;

    DualADC1_Handle.Instance = ADC1;  

    HAL_ADC_Init(&DualADC1_Handle);

    /* The total adc regular channels number */
    DualADC1_Handle.ChannelNum = 1;

    /* Add adc channels */
    ADC_RegChannelConf.Channel = ADC_CHANNEL_1;
    ADC_RegChannelConf.Sq = ADC_SEQUENCE_SQ1;
    ADC_RegChannelConf.Smp = ADC_SMP_CLOCK_320;
    ADC_RegChannelConf.SingleDiff = ADC_SINGLE_ENDED;  
    //offset config
    ADC_RegChannelConf.OffsetNumber =  ADC_OFFSET_NONE;
    ADC_RegChannelConf.Offset = 0;
    HAL_ADC_ConfigChannel(&DualADC1_Handle,&ADC_RegChannelConf);

    /*## ôADC2 ##*/
    DualADC2_Handle.Init.ClockPrescaler = ADC_CLOCK_DIV16;
    DualADC2_Handle.Init.Resolution     = ADC_RESOLUTION_12B;  
    DualADC2_Handle.Init.DataAlign      = ADC_DATAALIGN_RIGHT;  
    DualADC2_Handle.Init.ConConvMode    = DISABLE;
    DualADC2_Handle.Init.DiscontinuousConvMode = DISABLE;
    DualADC2_Handle.Init.ExternalTrigConv = ADC_SOFTWARE_START;
    DualADC2_Handle.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
    DualADC2_Handle.Init.DMAMode = ADC_DMAMODE_DISABLE;
    DualADC2_Handle.Init.OverMode = ADC_OVERMODE_DISABLE;
    //Oversampling mode
    DualADC2_Handle.Init.OverSampMode = ADC_OVERSAMPMODE_DISABLE;
    DualADC2_Handle.Init.Oversampling.Ratio =ADC_OVERSAMPLING_RATIO_2;
    DualADC2_Handle.Init.Oversampling.RightBitShift =ADC_RIGHTBITSHIFT_2;
    DualADC2_Handle.Init.Oversampling.TriggeredMode =0;
    DualADC2_Handle.Init.AnalogWDGEn = ADC_ANALOGWDGEN_DISABLE;
    DualADC2_Handle.Init.ChannelEn = ADC_CHANNEL_11_EN;

    DualADC2_Handle.Instance = ADC2;  

    HAL_ADC_Init(&DualADC2_Handle);

    /* The total adc regular channels number */
    DualADC2_Handle.ChannelNum = 1;

    /* Add adc channels */
    ADC_RegChannelConf.Channel = ADC_CHANNEL_11;
    ADC_RegChannelConf.Sq = ADC_SEQUENCE_SQ1;
    ADC_RegChannelConf.Smp = ADC_SMP_CLOCK_480;
    ADC_RegChannelConf.SingleDiff = ADC_SINGLE_ENDED;  
    //offset config
    ADC_RegChannelConf.OffsetNumber =  ADC_OFFSET_NONE;  
    ADC_RegChannelConf.Offset =  0;
    HAL_ADC_ConfigChannel(&DualADC2_Handle,&ADC_RegChannelConf);


    /*## ģʽ ##*/
    Multimode.Mode = ADC_DUALMODE_REGSIMULT;
    Multimode.DMAAccessMode = ADC_DMAACCESSMODE_12_10_BITS; //ADC_DMAACCESSMODE_8_6_BITS;    //ADC_DMAACCESSMODE_12_10_BITS
    ADC2->CR1 |=ADC_CR1_DMA;
    Multimode.TwoSamplingDelay =ADC_TWOSAMPLINGDELAY_5CYCLES;
    if(HAL_ADCEx_MultiModeConfigChannel(&DualADC1_Handle, &Multimode) != HAL_OK)
    {
        /* Channel Configuration Error */
        printfS("Multimode Configuration Error \r\n");
    }

    /*## DMA ##*/
    //ADC1
    __HAL_RCC_DMA1_CLK_ENABLE();
    DUAL_ADC1_DMAHandle.Instance = DMA1_Channel3;   
    DUAL_ADC1_DMAHandle.Init.ReqID = DMA1_REQ0_ADC1;   
    DUAL_ADC1_DMAHandle.Init.Mode = DMA_MODE_CIRCULAR;        
    DUAL_ADC1_DMAHandle.Init.DataFlow = DMA_DATAFLOW_P2M;
    DUAL_ADC1_DMAHandle.Init.SrcInc = DMA_SRCINC_DISABLE;
    DUAL_ADC1_DMAHandle.Init.DestInc = DMA_DESTINC_ENABLE;
    DUAL_ADC1_DMAHandle.Init.SrcWidth = DMA_SRCWIDTH_WORD;  
    DUAL_ADC1_DMAHandle.Init.DestWidth = DMA_DESTWIDTH_WORD; 
    DUAL_ADC1_DMAHandle.Init.SrcBurst = DMA_SRCBURST_1;
    DUAL_ADC1_DMAHandle.Init.DestBurst = DMA_DESTBURST_1;  
    DUAL_ADC1_DMAHandle.XferCpltCallback = DMA_ADC1_ITC_Callback;

    HAL_DMA_Init(&DUAL_ADC1_DMAHandle);
    DualADC1_Handle.DMA_Handle = &DUAL_ADC1_DMAHandle;
    
    NVIC_ClearPendingIRQ(DMA1_IRQn);
    NVIC_EnableIRQ(DMA1_IRQn);

    while(1)
    {

        /*polling mode*/
        __HAL_ADC_ENABLE(&DualADC1_Handle);
        __HAL_ADC_ENABLE(&DualADC2_Handle);

        HAL_ADC_Start(&DualADC1_Handle);
        HAL_ADC_Start(&DualADC2_Handle);
        //get ADC1 Reg channel val
        while(!READ_BIT(DualADC1_Handle.Instance->SR,ADC_SR_EOG)){};
        SET_BIT(DualADC1_Handle.Instance->SR,ADC_SR_EOG);

        gadcxConvertedRegValue = HAL_ADC_GetValue(&DualADC1_Handle);
        printfS("ADC1 convert result : Channel %d = 0x%08x. %d\r\n", gadcxConvertedRegValue >> 16 & 0xFF, gadcxConvertedRegValue, gadcxConvertedRegValue&0xfff);
        Voltage = (gadcxConvertedRegValue&0xFFF)*VrefP/4095;
        printfS("The Voltage is: %d mV \r\n", Voltage);  
        
        while(!READ_BIT(DualADC2_Handle.Instance->SR,ADC_SR_EOG)){};
        SET_BIT(DualADC2_Handle.Instance->SR,ADC_SR_EOG);
        gadcxConvertedRegValue = HAL_ADC_GetValue(&DualADC2_Handle);
        printfS("ADC2 convert result : Channel %d = 0x%08x. %d\r\n", gadcxConvertedRegValue >> 16 & 0xFF, gadcxConvertedRegValue, gadcxConvertedRegValue&0xfff);
        Voltage = (gadcxConvertedRegValue&0xFFF)*VrefP/4095;
        printfS("The Voltage is: %d mV \r\n", Voltage); 
        printfS("ADC_CDR = 0x%08x. \r\n", ADC12_COMMON->CDR);

        HAL_Delay(500);


        __HAL_ADC_ENABLE(&DualADC1_Handle);
        __HAL_ADC_ENABLE(&DualADC2_Handle);

        HAL_ADCEx_MultiModeStart_DMA(&DualADC1_Handle, gadcBuffer, DualADC1_Handle.ChannelNum);


        ADC1->CR1 |= ADC_CR1_SWSTART;


        while(!gadc1ItcCount);
        gadc1ItcCount =0;
        for (i = 0; i < DualADC1_Handle.ChannelNum; i++)
        {
            printfS("The adc convert result : ADC_CDR= 0x%08x . \r\n", gadcBuffer[i]);            
        }
        printfS("\r\n");

        HAL_Delay(500);
    }
}

/******************************************************************************
* @brief : Dual ADC Inject Simult Test.
* @param : none
* @return: none
******************************************************************************/ 
void Dual_ADC_InjSimult_Test(void)    
{
    uint32_t i, VrefP, Voltage;
    ADC_MultiModeTypeDef   Multimode;
    ADC_InjectionConfTypeDef sConfigInjected;

    /*## ADC1 ##*/
    DualADC1_Handle.Init.ClockPrescaler = ADC_CLOCK_DIV16;
    DualADC1_Handle.Init.Resolution     = ADC_RESOLUTION_12B;  
    DualADC1_Handle.Init.DataAlign      = ADC_DATAALIGN_RIGHT; 
    DualADC1_Handle.Init.ConConvMode    = DISABLE;
    DualADC1_Handle.Init.DiscontinuousConvMode = DISABLE;
    DualADC1_Handle.Init.ExternalTrigConv =  ADC_SOFTWARE_START; 
    DualADC1_Handle.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;   

    DualADC1_Handle.Init.DMAMode = ADC_DMAMODE_DISABLE;
    DualADC1_Handle.Init.OverMode = ADC_OVERMODE_DISABLE;
    //Oversampling mode
    DualADC1_Handle.Init.OverSampMode = ADC_OVERSAMPMODE_DISABLE;
    DualADC1_Handle.Init.Oversampling.Ratio =ADC_OVERSAMPLING_RATIO_2;
    DualADC1_Handle.Init.Oversampling.RightBitShift =ADC_RIGHTBITSHIFT_2;
    DualADC1_Handle.Init.Oversampling.TriggeredMode =0;
    DualADC1_Handle.Init.AnalogWDGEn = ADC_ANALOGWDGEN_DISABLE;
    DualADC1_Handle.Init.ChannelEn = ADC_CHANNEL_1_EN;

    DualADC1_Handle.Instance = ADC1;  

    HAL_ADC_Init(&DualADC1_Handle);

    /* The total adc regular channels number */
    DualADC1_Handle.ChannelNum = 1;

    /*ADC1 Channel Config */
    sConfigInjected.InjectedNbrOfConversion    = 1;
    sConfigInjected.InjectedChannel            = ADC_CHANNEL_1;
    sConfigInjected.InjectedRank               = ADC_INJECTED_RANK_1;
    sConfigInjected.InjectedSamplingTime       = ADC_SMP_CLOCK_320;
    sConfigInjected.InjectedSingleDiff         = ADC_SINGLE_ENDED;   //ADC_DIFFERENTIAL_ENDED;   

    sConfigInjected.ExternalTrigInjecConv      = ADC_SOFTWARE_START;
    sConfigInjected.ExternalTrigInjecConvEdge  = ADC_EXTERNALTRIGINJECCONVEDGE_NONE;

    sConfigInjected.AutoInjectedConv           = DISABLE;
    sConfigInjected.InjectedDiscontinuousConvMode = DISABLE;
    //offset
    sConfigInjected.InjectedOffsetNumber       = ADC_OFFSET_NONE;  //modeString[0].number;  
    sConfigInjected.InjectedOffset             = 0;
    //oversampling mode
    sConfigInjected.InjecOversamplingMode      = DISABLE;

    if(HAL_ADCEx_InjectedConfigChannel(&DualADC1_Handle, &sConfigInjected) != HAL_OK)
    {
        /* Channel Configuration Error */
        printfS("Inject Channel0 Configuration Error \r\n");
    }

    /*## ôADC2 ##*/
    DualADC2_Handle.Init.ClockPrescaler = ADC_CLOCK_DIV16;
    DualADC2_Handle.Init.Resolution     = ADC_RESOLUTION_12B;  
    DualADC2_Handle.Init.DataAlign      = ADC_DATAALIGN_RIGHT;  
    DualADC2_Handle.Init.ConConvMode    = DISABLE;
    DualADC2_Handle.Init.DiscontinuousConvMode = DISABLE;
    DualADC2_Handle.Init.ExternalTrigConv = ADC_SOFTWARE_START;
    DualADC2_Handle.Init.ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;
    DualADC2_Handle.Init.DMAMode = ADC_DMAMODE_DISABLE;
    DualADC2_Handle.Init.OverMode = ADC_OVERMODE_DISABLE;
    //Oversampling mode
    DualADC2_Handle.Init.OverSampMode = ADC_OVERSAMPMODE_DISABLE;
    DualADC2_Handle.Init.Oversampling.Ratio =ADC_OVERSAMPLING_RATIO_2;
    DualADC2_Handle.Init.Oversampling.RightBitShift =ADC_RIGHTBITSHIFT_2;
    DualADC2_Handle.Init.Oversampling.TriggeredMode =0;
    DualADC2_Handle.Init.AnalogWDGEn = ADC_ANALOGWDGEN_DISABLE;
    DualADC2_Handle.Init.ChannelEn = ADC_CHANNEL_11_EN;

    DualADC2_Handle.Instance = ADC2;  

    HAL_ADC_Init(&DualADC2_Handle);

    /* The total adc regular channels number */
    DualADC2_Handle.ChannelNum = 1;

    /* Add adc channels */
    sConfigInjected.InjectedNbrOfConversion    = 1;
    sConfigInjected.InjectedChannel            = ADC_CHANNEL_11;
    sConfigInjected.InjectedRank               = ADC_INJECTED_RANK_1;
    sConfigInjected.InjectedSamplingTime       = ADC_SMP_CLOCK_320;
    sConfigInjected.InjectedSingleDiff         = ADC_SINGLE_ENDED;   //ADC_DIFFERENTIAL_ENDED;   
    sConfigInjected.ExternalTrigInjecConv      = ADC_SOFTWARE_START;
    sConfigInjected.ExternalTrigInjecConvEdge  = ADC_EXTERNALTRIGINJECCONVEDGE_NONE;
    sConfigInjected.AutoInjectedConv           = DISABLE;
    sConfigInjected.InjectedDiscontinuousConvMode = DISABLE;
    //offset
    sConfigInjected.InjectedOffsetNumber       = ADC_OFFSET_NONE;  //modeString[0].number;  
    sConfigInjected.InjectedOffset             = 0;
    //oversampling mode
    sConfigInjected.InjecOversamplingMode      = DISABLE;

    if(HAL_ADCEx_InjectedConfigChannel(&DualADC2_Handle, &sConfigInjected) != HAL_OK)
    {
        /* Channel Configuration Error */
        printfS("Inject Channel0 Configuration Error \r\n");
    }

    /*## ģʽ ##*/
    Multimode.Mode = ADC_DUALMODE_INJECSIMULT;
    Multimode.DMAAccessMode = ADC_DMAACCESSMODE_DISABLED;
    ADC2->CR1 |=ADC_CR1_DMA;
    Multimode.TwoSamplingDelay =ADC_TWOSAMPLINGDELAY_5CYCLES;
    if(HAL_ADCEx_MultiModeConfigChannel(&DualADC1_Handle, &Multimode) != HAL_OK)
    {
        /* Channel Configuration Error */
        printfS("Multimode Configuration Error \r\n");
    }
    
    VrefP = ADC_GetVrefP();
    printfS("The VrefP value is : %d \r\n", VrefP);
    
    while(1)
    {
        __HAL_ADC_ENABLE(&DualADC1_Handle);
        __HAL_ADC_ENABLE(&DualADC2_Handle);

        HAL_ADCEx_InjectedStart(&DualADC1_Handle);

        while(!READ_BIT(DualADC1_Handle.Instance->SR,ADC_SR_JEOC)){};
        SET_BIT(DualADC1_Handle.Instance->SR,ADC_SR_JEOC);			
        gadcxConvertedRegValue = HAL_ADCEx_InjectedGetValue(&DualADC1_Handle,ADC_INJECTED_RANK_1);
        printfS("The ADC1 Inject Rank1 convert result : Channel %d = %d\r\n", (gadcxConvertedRegValue>>16 & 0xFF), (gadcxConvertedRegValue&0xfff)); 
        Voltage = (gadcxConvertedRegValue&0xFFF)*VrefP/4095;
        printfS("The Voltage is: %d mV \r\n", Voltage);  
        
        while(!READ_BIT(DualADC2_Handle.Instance->SR,ADC_SR_JEOC)){};
        SET_BIT(DualADC2_Handle.Instance->SR,ADC_SR_JEOC);			
        gadcxConvertedRegValue = HAL_ADCEx_InjectedGetValue(&DualADC2_Handle,ADC_INJECTED_RANK_1);
        printfS("The ADC2 Inject Rank1 convert result : Channel %d = %d\r\n", gadcxConvertedRegValue>>16 & 0xFF, (gadcxConvertedRegValue&0xfff)); 	
        Voltage = (gadcxConvertedRegValue&0xFFF)*VrefP/4095;
        printfS("The Voltage is: %d mV \r\n", Voltage); 
        
        HAL_Delay(500);			
    }
}


/******************************************************************************
* @brief : Dual ADC test.
* @param : Test_CaseTest mode selection
* @return: none
******************************************************************************/ 
void Dual_ADC_Test(Dual_ADC_Test_mode Test_Case)
{
    switch(Test_Case)
    {
        case Dual_ADC_RegSimult:
            Dual_ADC_RegSimult_Test();
        break;
        case Dual_ADC_InjSimult:
            Dual_ADC_InjSimult_Test();
        break;
        default:break;

    }
}



