
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h"

void HAL_UART_MspDeInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspDeInit can be implemented in the user file.
    */    
    if (huart->Instance == UART1) 
    {
        /* Disable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();

        /* DeInitialization GPIO */
        /* A9:Tx  A10:Rx */
        HAL_GPIO_DeInit(GPIOA,GPIO_PIN_9 | GPIO_PIN_10);
		
		if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_11);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_12);
        }
		
        /* NVIC DeInit */
        NVIC_DisableIRQ(UART1_IRQn);
		
    }
	else if(huart->Instance == UART2)
	{

	}
}

void HAL_ADC_MspInit(ADC_HandleTypeDef* hadc)
{
    uint32_t i;
    GPIO_InitTypeDef GPIO_Handle; 
    uint32_t ADC_Pin_Map[][3] =
    {
        { ADC_CHANNEL_0_EN, (uint32_t)GPIOA, GPIO_PIN_0 }, 
        { ADC_CHANNEL_1_EN, (uint32_t)GPIOA, GPIO_PIN_1 },
        { ADC_CHANNEL_2_EN, (uint32_t)GPIOA, GPIO_PIN_2 },
        { ADC_CHANNEL_3_EN, (uint32_t)GPIOA, GPIO_PIN_3 },
        { ADC_CHANNEL_4_EN, (uint32_t)GPIOA, GPIO_PIN_4 },
        { ADC_CHANNEL_5_EN, (uint32_t)GPIOA, GPIO_PIN_5 },
        { ADC_CHANNEL_6_EN, (uint32_t)GPIOA, GPIO_PIN_6 },
        { ADC_CHANNEL_7_EN, (uint32_t)GPIOA, GPIO_PIN_7 },
        { ADC_CHANNEL_8_EN, (uint32_t)GPIOB, GPIO_PIN_0 },
        { ADC_CHANNEL_9_EN, (uint32_t)GPIOB, GPIO_PIN_1 },
        { ADC_CHANNEL_10_EN, (uint32_t)GPIOC, GPIO_PIN_0 },
        { ADC_CHANNEL_11_EN, (uint32_t)GPIOC, GPIO_PIN_1 },
        { ADC_CHANNEL_12_EN, (uint32_t)GPIOC, GPIO_PIN_2 },
        { ADC_CHANNEL_13_EN, (uint32_t)GPIOC, GPIO_PIN_3 },
        { ADC_CHANNEL_14_EN, (uint32_t)GPIOC, GPIO_PIN_4 },
        { ADC_CHANNEL_15_EN, (uint32_t)GPIOC, GPIO_PIN_5 },
        { 0xffffffff, 0 }, //־
    };    

    __HAL_RCC_GPIOA_CLK_ENABLE();
    __HAL_RCC_GPIOB_CLK_ENABLE();
    __HAL_RCC_GPIOC_CLK_ENABLE();

    //Set gpio to analog.
    for(i = 0; ADC_Pin_Map[i][0] != 0xffffffff; i++)
    {
        if(hadc->Init.ChannelEn & ADC_Pin_Map[i][0])
        {
            GPIO_Handle.Pin            = ADC_Pin_Map[i][2];
            GPIO_Handle.Mode           = GPIO_MODE_ANALOG;
            GPIO_Handle.Pull           = GPIO_NOPULL;
            HAL_GPIO_Init((GPIO_TypeDef *)ADC_Pin_Map[i][1], &GPIO_Handle);   
        }
    }

    /* Enable ADC Clock */
    __HAL_RCC_ADC12_CLK_ENABLE();
    /* Clear Pending Interrupt */
    NVIC_ClearPendingIRQ(ADC12_IRQn);	
    /* Enable External Interrupt */
    NVIC_EnableIRQ(ADC12_IRQn);
  
}

void HAL_UART_MspInit(UART_HandleTypeDef *huart)
{
    GPIO_InitTypeDef    GPIO_Uart = {0};

    if (huart->Instance == UART1) 
    {
        /* Initialization GPIO */
        /* A9:Tx  A10:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_9 | GPIO_PIN_10;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;

        HAL_GPIO_Init(GPIOA, &GPIO_Uart);

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_11;

            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_12;

            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        /* Enable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART1_IRQn);
        NVIC_SetPriority(UART1_IRQn, 5);
        NVIC_EnableIRQ(UART1_IRQn);
    }

    if (huart->Instance == UART2) 
    {
        /* Initialization GPIO */
        /* A2:Tx  A3:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;

        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        /* Enable Clock */
        __HAL_RCC_UART2_CLK_ENABLE();

    }
}

