/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/
#include "hal.h"

/******************************************************************************
*@brief : Initialize the CAN MSP.
*         
*@param : hcan: pointer to a CAN_HandleTypeDef structure that contains
*                      the configuration information for CAN module
*
*@return: None
******************************************************************************/
void HAL_CAN_MspInit(CAN_HandleTypeDef *hcan)
{
    /* NOTE : This function should not be modified, when the callback is needed,
                the HAL_UART_MspInit can be implemented in the user file
    */
    /* For Example */
    GPIO_InitTypeDef GPIO_InitStructure={0};
    
    if(hcan->Instance == CAN1)
    {
        /* Enable CAN clock */
        __HAL_RCC_CAN1_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();

        __HAL_RCC_CAN1_RESET();

        /* Initialization GPIO */
        /* PB8:Rx */  /* PB9:Tx */
        GPIO_InitStructure.Pin       = GPIO_PIN_8 | GPIO_PIN_9;	
        GPIO_InitStructure.Alternate = GPIO_FUNCTION_6;
        GPIO_InitStructure.Pull      = GPIO_PULLUP;
        GPIO_InitStructure.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStructure.Drive     = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOB, &GPIO_InitStructure);
        printfS("CAN1 configured as to use PB8(RX), PB9(TX)\r\n\r\n");

        NVIC_ClearPendingIRQ(CAN1_IRQn);
        NVIC_SetPriority(CAN1_IRQn, 5);
        NVIC_EnableIRQ(CAN1_IRQn); 
    }
    else if(hcan->Instance == CAN2)
    {
        /* Enable CAN clock */
        __HAL_RCC_CAN2_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();

        __HAL_RCC_CAN2_RESET();

        /* Initialization GPIO */
        /* PB5:Rx */  /* PB6:Tx */
        GPIO_InitStructure.Pin       = GPIO_PIN_5 | GPIO_PIN_6;	
        GPIO_InitStructure.Alternate = GPIO_FUNCTION_4;
        GPIO_InitStructure.Pull      = GPIO_PULLUP;
        GPIO_InitStructure.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStructure.Drive     = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOB, &GPIO_InitStructure);
        printfS("CAN2 configured as to use PB5(RX), PB6(TX)\r\n\r\n");
        
        NVIC_ClearPendingIRQ(CAN2_IRQn);
        NVIC_SetPriority(CAN2_IRQn, 5);
        NVIC_EnableIRQ(CAN2_IRQn); 
    }
}

/******************************************************************************
*@brief : CAN MSP De-Initialization 
*         This function frees the hardware resources used in this example:
*              - Disable the Peripheral's clock
*              - Revert GPIO configuration to their default state
*         
*@param : hcan: pointer to a CAN_HandleTypeDef structure that contains
*                      the configuration information for CAN module
*
*@return: None
******************************************************************************/
void HAL_CAN_MspDeInit(CAN_HandleTypeDef *hcan)
{
    GPIO_InitTypeDef GPIO_InitStructure;
    
    if(hcan->Instance == CAN1)
    {
        /* Reset CAN clock */
        __HAL_RCC_CAN1_CLK_DISABLE();

        /* De-Initialization GPIO */
        /* PD0:Rx */  /* PD1:Tx */
        HAL_GPIO_DeInit(GPIOD, GPIO_PIN_0);
        HAL_GPIO_DeInit(GPIOD, GPIO_PIN_1);
    }
    else if(hcan->Instance == CAN2)
    {
        /* Reset CAN clock */
        __HAL_RCC_CAN2_CLK_DISABLE();
        
        GPIO_InitTypeDef GPIO_InitStructure;   	
        /* De-Initialization GPIO */
        /* PB5:Rx */  /* PB6:Tx */
        HAL_GPIO_DeInit(GPIOB, GPIO_PIN_5);
        HAL_GPIO_DeInit(GPIOB, GPIO_PIN_6);
    }
}

