
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   
#include "main.h"

#define PWM_OUTPUT_CHANNEL    TIM_CHANNEL_5   

#define TIM_CLOCK_FREQ            (8000000U)  

TIM_HandleTypeDef TIM1_Handler;   

COMP_HandleTypeDef COMP1_handle;

void COMP1_Init(void)
{
    HAL_RCC_FLTClockSourceConfig(RCC_FLTCLKSOURCE_PCLK_DIV32);
    
    COMP1_handle.Instance = COMP;
    COMP1_handle.Init.COMPx = COMP1;
    COMP1_handle.Init.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.Init.InMSel = COMP1_INMSEL_PA4;
    COMP1_handle.Init.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.Init.HYS = COMP_HYS_7;
    COMP1_handle.Init.BlankSel = COMP1_BLANKSEL_TIM1_OC5;
    COMP1_handle.Init.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.Init.WinOut = COMP_WINOUT_DIRECT;
    COMP1_handle.Init.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.Init.FltTime = COMP_FLTTIME_4CLK;
    
    HAL_COMP_Init(&COMP1_handle);
}
/*********************************************************************************
* Function    : TIM1_Init      
* Description : timer 1 initiation, includes clock, io, configuration 
* Input       : none    
* Output      : none 
* Author      : xwl                       
**********************************************************************************/  
void TIM1_Init(void)  
{  
	TIM_OC_InitTypeDef Tim_OC_Init_Para;   
    uint32_t timer_clock;
    
    timer_clock = HAL_RCC_GetPCLK2Freq();  // TIM1 is on APB2  
    
    if (HAL_RCC_GetHCLKFreq() != timer_clock)  // if hclk/pclk != 1, then timer clk = pclk * 2  
    {
       timer_clock =  timer_clock << 1;     
    }
	
	TIM1_Handler.Instance = TIM1;
	TIM1_Handler.Init.ARRPreLoadEn = TIM_ARR_PRELOAD_ENABLE;        
	TIM1_Handler.Init.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM1_Handler.Init.CounterMode = TIM_COUNTERMODE_UP; 
	TIM1_Handler.Init.RepetitionCounter = 0;  
	TIM1_Handler.Init.Prescaler = (timer_clock/TIM_CLOCK_FREQ) - 1; 
	if (timer_clock%TIM_CLOCK_FREQ > TIM_CLOCK_FREQ/2) 
	{
		TIM1_Handler.Init.Prescaler = TIM1_Handler.Init.Prescaler + 1;  
	}
	TIM1_Handler.Init.Period = (TIM_CLOCK_FREQ/1000)*1 - 1;  // period = 1ms     
    TIM1_MSP_Pre_Init(&TIM1_Handler);   
	  
	HAL_TIMER_Base_Init(&TIM1_Handler);  
	
	Tim_OC_Init_Para.OCMode = OUTPUT_MODE_PWM1;  
	Tim_OC_Init_Para.OCIdleState = OUTPUT_IDLE_STATE_0;
	Tim_OC_Init_Para.OCNIdleState = OUTPUT_IDLE_STATE_0;      
	Tim_OC_Init_Para.OCPolarity = OUTPUT_POL_ACTIVE_HIGH;  
	Tim_OC_Init_Para.OCNPolarity = OUTPUT_POL_ACTIVE_HIGH;    
	Tim_OC_Init_Para.OCFastMode =  OUTPUT_FAST_MODE_DISABLE;  
	Tim_OC_Init_Para.Pulse = (TIM1_Handler.Init.Period + 1)/2;   // 50% duty cycle   	
	HAL_TIMER_Output_Config(TIM1_Handler.Instance, &Tim_OC_Init_Para, PWM_OUTPUT_CHANNEL);    
          
}



void APP_Test(void)
{
    printfS("COMP1 Blanksel Test\r\n");
    
    TIM1_Init(); 
    HAL_TIM_PWM_Output_Start(TIM1_Handler.Instance, PWM_OUTPUT_CHANNEL);   
    
    COMP1_Init();
    HAL_COMP_Start(&COMP1_handle);
}