
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   
#include "main.h"

COMP_HandleTypeDef COMP1_handle;
DAC_HandleTypeDef hdac1;
/******************************************************************************
* @brief : DAC output voltage initialization.
* @param : None.
* @return: None
******************************************************************************/
void DAC_Config_OutPut_Voltage()
{
    hdac1.Instance = DAC;
    HAL_DAC_Init(&hdac1);

    DAC_ChannelConfTypeDef sConfig; 
    sConfig.DAC_Trigger = DAC_TRIGGER_SOFTWARE;
    sConfig.DAC_Trigger2 = DAC_TRIGGER_SOFTWARE;
    sConfig.DAC_SampleAndHold = DAC_SAMPLEANDHOLD_DISABLE;
    sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_DISABLE;
    sConfig.DAC_ConnectOnChipPeripheral = DAC_CHIPCONNECT_INTERNAL;  
    sConfig.DAC_UserTrimming = DAC_TRIMMING_FACTORY;

    HAL_DAC_ConfigChannel(&hdac1, &sConfig,DAC_CHANNEL_2);

    /* ԶУ׼ɸҪ/ر */
    HAL_DACEx_SelfCalibrate(&hdac1, &sConfig,DAC_CHANNEL_2);
    HAL_SimpleDelay(500000);
}
/******************************************************************************
* @brief : DAC output voltage.
* @param : voltage output voltage value.
* @return: None
******************************************************************************/
void DAC_OutPutVoltage(float voltage)
{
    if( voltage > 3.3)
    {
        return;
    }
    uint16_t data=((voltage / 3.3) * 4095);
    HAL_DACEx_DualSetValue(&hdac1,DAC_ALIGN_12B_R,data,data);
    HAL_DAC_Start(&hdac1, DAC_CHANNEL_2);
}
void COMP1_Init(void)
{
    HAL_RCC_FLTClockSourceConfig(RCC_FLTCLKSOURCE_PCLK_DIV32);
    
    COMP1_handle.Instance = COMP;
    COMP1_handle.Init.COMPx = COMP1;
    COMP1_handle.Init.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.Init.InMSel = COMP1_INMSEL_DAC1;
    COMP1_handle.Init.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.Init.HYS = COMP_HYS_7;
    COMP1_handle.Init.BlankSel = COMP_BLANKSEL_NONE;
    COMP1_handle.Init.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.Init.WinOut = COMP_WINOUT_DIRECT;
    COMP1_handle.Init.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.Init.FltTime = COMP_FLTTIME_4CLK;
    
    HAL_COMP_Init(&COMP1_handle);
}


void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
    printfS("DAC Output Voltage\r\n\r\n");
    DAC_Config_OutPut_Voltage();
    DAC_OutPutVoltage(2.5);
    COMP1_Init();
    HAL_COMP_Start(&COMP1_handle);
    
   

}