
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h"

void HAL_UART_MspInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspInit can be implemented in the user file.
    */

    /* For Example */
    GPIO_InitTypeDef    GPIO_Uart = {0};
    
    if (huart->Instance == UART1) 
    {
        /* Initialization GPIO */
        /* A9:Tx  A10:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_9 | GPIO_PIN_10;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_11;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_12;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        /* Enable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART1_IRQn);
        NVIC_SetPriority(UART1_IRQn, 5);
        NVIC_EnableIRQ(UART1_IRQn);
    }
    
    if (huart->Instance == UART2) 
    {
        /* Initialization GPIO */
        /* A2:Tx  A3:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_0;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_1;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        /* Enable Clock */
        __HAL_RCC_UART2_CLK_ENABLE();
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART2_IRQn);
        NVIC_SetPriority(UART2_IRQn, 5);
        NVIC_EnableIRQ(UART2_IRQn);
    }
}

void HAL_UART_MspDeInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspDeInit can be implemented in the user file.
    */    
    if (huart->Instance == UART1) 
    {
        /* Disable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();

        /* DeInitialization GPIO */
        /* A9:Tx  A10:Rx */
        HAL_GPIO_DeInit(GPIOA,GPIO_PIN_9 | GPIO_PIN_10);
		
		if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_11);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_12);
        }
		
        /* NVIC DeInit */
        NVIC_DisableIRQ(UART1_IRQn);
		
    }
	else if(huart->Instance == UART2)
	{

	}
}


/******************************************************************************
*@brief : COMP MSP Initialization.such as module clock, IO share, ... 
*           COMP1 VinP: PA1, PB1, PB10
*           COMP1 VinM: PA4, PA0, DAC1, VREF_AVDD
*           COMP1 Vout: PA0(AF6), PA6(AF6), PA11(AF6), PB0(AF6), PB8(AF7), PB10(AF6)
*               
*           COMP2 VinP: PA7, PA3, PB11
*           COMP2 VinM: PA5, PA2, DAC2, VREF_AVDD
*           COMP2 Vout: PA2(AF6), PA7(AF6), PA12(AF6), PB5(AF6), PB9(AF7), PB11(AF6) 
*               
*           COMP3 VinP: PA0, PC1, PC3
*           COMP3 VinM: PF1, PC0, DAC1, VREF_AVDD
*           COMP3 Vout: PB7(AF7), PB15(AF6), PC2(AF7)
* 
*           COMP4 VinP: PB0, PE7, PE9
*           COMP4 VinM: PE8, PB2, DAC1, VREF_AVDD
*           COMP4 Vout: PB1(AF7), PB6(AF10), PB14(AF7)
*@param : hcomp: COMP handle
*@return: None
******************************************************************************/
void HAL_COMP_MspInit(COMP_HandleTypeDef* hcomp)
{
    
    GPIO_InitTypeDef GPIO_Handle; 
    
    //Enable COMP clock
    __HAL_RCC_COMP_CLK_ENABLE();
    
    if(hcomp->Init.COMPx == COMP1)
    {     
        //VINP:PA1, VINM:PA4, VOUT:PA0(AF6)
        
        __HAL_RCC_GPIOA_CLK_ENABLE();
        
        GPIO_Handle.Pin     = GPIO_PIN_1;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;        
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin     = GPIO_PIN_4;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin            = GPIO_PIN_0;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_NOPULL;        
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_6;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
    }
    else if(hcomp->Init.COMPx == COMP2)
    {
        //VINP:PA7, VINM:PA5, VOUT:PA12(AF6)
        
        __HAL_RCC_GPIOA_CLK_ENABLE();        
        
        GPIO_Handle.Pin     = GPIO_PIN_7;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;        
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin     = GPIO_PIN_5;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin            = GPIO_PIN_12;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_NOPULL;        
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_6;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
    }
    
    else if(hcomp->Init.COMPx == COMP3)
    {
        //VINP:PC1, VINM:PC0, VOUT:PC2(AF7)
        
        __HAL_RCC_GPIOC_CLK_ENABLE();        
        
        GPIO_Handle.Pin     = GPIO_PIN_1;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;        
        HAL_GPIO_Init(GPIOC, &GPIO_Handle);
        
        GPIO_Handle.Pin     = GPIO_PIN_0;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOC, &GPIO_Handle);
        
        GPIO_Handle.Pin            = GPIO_PIN_2;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_NOPULL;        
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_7;
        HAL_GPIO_Init(GPIOC, &GPIO_Handle);
    }    
    
    else if(hcomp->Init.COMPx == COMP4)
    {
        //VINP:PB0, VINM:PB2, VOUT:PB1(AF7)
        
        __HAL_RCC_GPIOB_CLK_ENABLE();        
        
        GPIO_Handle.Pin     = GPIO_PIN_0;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;        
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
        
        GPIO_Handle.Pin     = GPIO_PIN_2;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
        
        GPIO_Handle.Pin            = GPIO_PIN_1;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_NOPULL;        
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_7;
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
    }    
    
}
/******************************************************************************
*@brief : COMP MSP De-Initialization.This function freeze the hardware resources used in this example. 
*@param : hcomp: COMP handle
*@return: None
******************************************************************************/
void HAL_COMP_MspDeInit(COMP_HandleTypeDef* hcomp)
{
    if(hcomp->Init.COMPx == COMP1)
    {     
        //VINP:PA1, VINM:PA4, VOUT:PA0(AF6)
        
        HAL_GPIO_DeInit(GPIOA, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_4);
    }
    else if(hcomp->Init.COMPx == COMP2)
    {
        //VINP:PA7, VINM:PA5, VOUT:PA12(AF6)
        
        HAL_GPIO_DeInit(GPIOA, GPIO_PIN_5 | GPIO_PIN_7 | GPIO_PIN_12);
    }
    
    else if(hcomp->Init.COMPx == COMP3)
    {
        //VINP:PC1, VINM:PC0, VOUT:PC2(AF7)
        
        HAL_GPIO_DeInit(GPIOC, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2);
    }    
    
    else if(hcomp->Init.COMPx == COMP4)
    {
        //VINP:PB0, VINM:PB2, VOUT:PB1(AF7)
        
        HAL_GPIO_DeInit(GPIOB, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_2);
    } 
}




