
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   
#include "main.h"

COMP_HandleTypeDef COMP1_handle;
COMP_HandleTypeDef COMP2_handle;
void COMP1_Init(void)
{
    HAL_RCC_FLTClockSourceConfig(RCC_FLTCLKSOURCE_PCLK_DIV32);
    //VINP:PA1, VINM:PA4, VOUT:PA0(AF6)
    COMP1_handle.Instance = COMP;
    COMP1_handle.Init.COMPx = COMP1;
    COMP1_handle.Init.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.Init.InMSel = COMP1_INMSEL_PA4;
    COMP1_handle.Init.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.Init.HYS = COMP_HYS_7;
    COMP1_handle.Init.BlankSel = COMP_BLANKSEL_NONE;
    COMP1_handle.Init.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.Init.WinOut = COMP_WINOUT_XOR;
    COMP1_handle.Init.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.Init.FltTime = COMP_FLTTIME_4CLK;
    
    HAL_COMP_Init(&COMP1_handle);
}

void COMP2_Init(void)
{
    HAL_RCC_FLTClockSourceConfig(RCC_FLTCLKSOURCE_PCLK_DIV32);
    //VINP:PA7, VINM:PA5, VOUT:PA12(AF6)
    COMP2_handle.Instance = COMP;
    COMP2_handle.Init.COMPx = COMP2;
    COMP2_handle.Init.InPSel = COMP2_INPSEL_PA7;
    COMP2_handle.Init.InMSel = COMP2_INMSEL_PA5;
    COMP2_handle.Init.Polarity = COMP_POLARITY_NOINVERT;
    COMP2_handle.Init.HYS = COMP_HYS_7;
    COMP2_handle.Init.BlankSel = COMP_BLANKSEL_NONE;
    COMP2_handle.Init.WinMode = COMP_WINMODE_ANOTHER_INP;
    COMP2_handle.Init.WinOut = COMP_WINOUT_DIRECT;
    COMP2_handle.Init.FltEn = COMP_FLT_ENABLE;
    COMP2_handle.Init.FltTime = COMP_FLTTIME_4CLK;
    
    HAL_COMP_Init(&COMP2_handle);
}
void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
    COMP1_Init();
    COMP2_Init();
    HAL_COMP_Start(&COMP1_handle);
    HAL_COMP_Start(&COMP2_handle);
    
   

}