
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h"

void HAL_UART_MspInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspInit can be implemented in the user file.
    */

    /* For Example */
    GPIO_InitTypeDef    GPIO_Uart = {0};
    
    if (huart->Instance == UART1) 
    {
        /* Enable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();
        __HAL_RCC_GPIOA_CLK_ENABLE();
        /* A9:Tx  A10:Rx */
        GPIO_Uart.Pin       = GPIO_PIN_9 | GPIO_PIN_10;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_11;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_12;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART1_IRQn);
        NVIC_SetPriority(UART1_IRQn, 5);
        NVIC_EnableIRQ(UART1_IRQn);
    }
    else if (huart->Instance == UART2) 
    {
        /* Enable Clock */
        __HAL_RCC_UART2_CLK_ENABLE();
        __HAL_RCC_GPIOA_CLK_ENABLE();
        /* A2:Tx  A3:Rx */
        GPIO_Uart.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A0:CTS */
            GPIO_Uart.Pin = GPIO_PIN_0;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A1:RTS */
            GPIO_Uart.Pin = GPIO_PIN_1;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART2_IRQn);
        NVIC_SetPriority(UART2_IRQn, 5);
        NVIC_EnableIRQ(UART2_IRQn);
    }
    else if(huart->Instance == UART3)
    {
        /* Enable Clock */
        __HAL_RCC_GPIOB_CLK_ENABLE();
        __HAL_RCC_UART3_CLK_ENABLE();
        /* B10:Tx  B11:Rx */
        GPIO_Uart.Pin       = GPIO_PIN_10 | GPIO_PIN_11;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOB, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* B13:CTS */
            GPIO_Uart.Pin = GPIO_PIN_13;
            GPIO_Uart.Alternate = GPIO_FUNCTION_0;
            HAL_GPIO_Init(GPIOB, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* B14:RTS */
            GPIO_Uart.Pin = GPIO_PIN_14;
            GPIO_Uart.Alternate = GPIO_FUNCTION_0;
            HAL_GPIO_Init(GPIOB, &GPIO_Uart);
        }
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART3_IRQn);
        NVIC_SetPriority(UART3_IRQn, 5);
        NVIC_EnableIRQ(UART3_IRQn);
    }
    else if(huart->Instance == UART4)
    {
        /* Enable Clock */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();
        __HAL_RCC_UART4_CLK_ENABLE();
        /* A0:Tx  A1:Rx */
        GPIO_Uart.Pin       = GPIO_PIN_0 | GPIO_PIN_1;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_3;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* B7:CTS */
            GPIO_Uart.Pin = GPIO_PIN_7;
            GPIO_Uart.Alternate = GPIO_FUNCTION_4;
            HAL_GPIO_Init(GPIOB, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A15:RTS */
            GPIO_Uart.Pin = GPIO_PIN_15;
            GPIO_Uart.Alternate = GPIO_FUNCTION_3;
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART4_IRQn);
        NVIC_SetPriority(UART4_IRQn, 5);
        NVIC_EnableIRQ(UART4_IRQn);
    }
}

void HAL_DAC_MspInit(DAC_HandleTypeDef *hdac)
{
    if(hdac->Instance==DAC)
    { 
        /* Enable DAC clock */
        __HAL_RCC_DAC1_CLK_ENABLE();
        __HAL_RCC_GPIOA_CLK_ENABLE();
        
        GPIO_InitTypeDef GPIO_InitStructure;   	
        /* Initialization GPIO */
        /**DAC1 GPIO Configuration    
        PA4  ------> DAC_OUT1 
        PA5  ------> DAC_OUT2 
        */
        
        GPIO_InitStructure.Pin = GPIO_PIN_4|GPIO_PIN_5;	
        GPIO_InitStructure.Pull=GPIO_NOPULL;
        GPIO_InitStructure.Mode = GPIO_MODE_ANALOG;
        HAL_GPIO_Init(GPIOA, &GPIO_InitStructure);
        
        printfS("DAC Channel-1:PA4\r\n");
        printfS("DAC Channel-2:PA5\r\n");
        
        /* Enable the DAC DMA underrun interrupt */
        hdac->Instance->CR |= DAC_CR_DMAUDIE1 | DAC_CR_DMAUDIE2;
        NVIC_ClearPendingIRQ(DAC_IRQn);
        NVIC_SetPriority(DAC_IRQn, 5);
        NVIC_EnableIRQ(DAC_IRQn);
    }
}

