
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   


#define    DMA_TRANSFER_BUF_SIZE    ( 12U )

__attribute__ ((aligned (4)))	uint8_t g_srcBuf[DMA_TRANSFER_BUF_SIZE];
__attribute__ ((aligned (4)))	uint8_t g_destBuf[DMA_TRANSFER_BUF_SIZE];

DMA_HandleTypeDef DMA1_Ch1Handle;


/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    uint32_t Error;
    
	BSP_LED_Init();
	
	BSP_LED_On();
    HAL_Delay(500);
    
	__HAL_RCC_DMA1_CLK_ENABLE();
	
	DMA1_Ch1Handle.Instance          = DMA1_Channel0;
	DMA1_Ch1Handle.Init.Mode         = DMA_MODE_NORMAL;
	DMA1_Ch1Handle.Init.DataFlow     = DMA_DATAFLOW_M2M;
	DMA1_Ch1Handle.Init.ReqID        = DMA1_REG_M2M;
	DMA1_Ch1Handle.Init.SrcInc       = DMA_SRCINC_ENABLE;
	DMA1_Ch1Handle.Init.DestInc      = DMA_DESTINC_ENABLE;
	DMA1_Ch1Handle.Init.SrcWidth     = DMA_SRCWIDTH_BYTE;
	DMA1_Ch1Handle.Init.DestWidth    = DMA_DESTWIDTH_BYTE;
	DMA1_Ch1Handle.Init.SrcBurst     = DMA_SRCBURST_1;
	DMA1_Ch1Handle.Init.DestBurst    = DMA_DESTBURST_1;
	
	HAL_DMA_Init(&DMA1_Ch1Handle);
	
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
        g_srcBuf[i] = i & 0xffu;
    
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
        g_destBuf[i] = 0;
    
    __HAL_DMA_CLEAR_HFTC_IT_FLAG(&DMA1_Ch1Handle);
    __HAL_DMA_CLEAR_TC_IT_FLAG(&DMA1_Ch1Handle);
    __HAL_DMA_CLEAR_ERR_IT_FLAG(&DMA1_Ch1Handle);
    
    HAL_DMA_Start(&DMA1_Ch1Handle, (uint32_t)g_srcBuf, (uint32_t)g_destBuf, DMA_TRANSFER_BUF_SIZE);
    
    while (HAL_DMA_GetState(&DMA1_Ch1Handle, DMA_FLAG_RTC) == RESET);
    
	Error = 0u;
    if (memcmp((void *)g_srcBuf, (void *)g_destBuf, DMA_TRANSFER_BUF_SIZE) != 0u)
        Error = 1u;
	
	if (Error == 0)
	{
		printfS("test result: successful!\r\n");
	}
	else
	{
		printfS("test result: failed!\r\n");
	}
	
    while(1)
    {
		if (Error == 0)
		{
			BSP_LED_Toggle();
		}
		else
		{
			BSP_LED_Off();
		}
		HAL_Delay(500);
    };
}
