
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   


#define    DMA_TRANSFER_BUF_SIZE    ( 1024U )

__attribute__ ((aligned (4)))	uint8_t g_srcBuf[DMA_TRANSFER_BUF_SIZE];
__attribute__ ((aligned (4)))	uint8_t g_destBuf[DMA_TRANSFER_BUF_SIZE];

DMA_HandleTypeDef DMA1_Ch1Handle;

volatile uint32_t g_TransferComplete = 0;

void DMATransferComplete(DMA_HandleTypeDef *hdma1);

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    uint32_t Error;
    
	BSP_LED_Init();
	
	BSP_LED_On();
    HAL_Delay(500);
    
	__HAL_RCC_DMA1_CLK_ENABLE();
	
	DMA1_Ch1Handle.Instance          = DMA1_Channel0;
	DMA1_Ch1Handle.Init.Mode         = DMA_MODE_CIRCULAR;
	DMA1_Ch1Handle.Init.DataFlow     = DMA_DATAFLOW_M2M;
	DMA1_Ch1Handle.Init.ReqID        = DMA1_REG_M2M;
	DMA1_Ch1Handle.Init.SrcInc       = DMA_SRCINC_ENABLE;
	DMA1_Ch1Handle.Init.DestInc      = DMA_DESTINC_ENABLE;
	DMA1_Ch1Handle.Init.SrcWidth     = DMA_SRCWIDTH_BYTE;
	DMA1_Ch1Handle.Init.DestWidth    = DMA_DESTWIDTH_BYTE;
	DMA1_Ch1Handle.Init.SrcBurst     = DMA_SRCBURST_4;
	DMA1_Ch1Handle.Init.DestBurst    = DMA_DESTBURST_4;
	
	HAL_DMA_Init(&DMA1_Ch1Handle);
	
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
        g_srcBuf[i] = i & 0xffu;
    
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
        g_destBuf[i] = 0;
    
	NVIC_ClearPendingIRQ(DMA1_IRQn);
	NVIC_SetPriority(DMA1_IRQn, 0);
	NVIC_EnableIRQ(DMA1_IRQn);
	
    g_TransferComplete = 0;
    
    HAL_DMA_RegisterCallback(&DMA1_Ch1Handle, DMA_XFER_CPLT_CB_ID, DMATransferComplete);
    
    HAL_DMA_Start_IT(&DMA1_Ch1Handle, (uint32_t)g_srcBuf, (uint32_t)g_destBuf, DMA_TRANSFER_BUF_SIZE);
    
    while(1)
    {
        printfS("transfer complet count: %u\r\n", g_TransferComplete);
		HAL_Delay(500);
        BSP_LED_Toggle();
    };
}

void DMATransferComplete(DMA_HandleTypeDef *hdma1)
{
    UNUSED(hdma1);
    
    g_TransferComplete++;
}

