
/******************************************************************************
*@file  : app.h
*@brief : application
******************************************************************************/

#ifndef __APP_H
#define __APP_H

#include "hal.h"
#include "fonts.h"


/*  LCD оƬ ID */
#define LCDID_UNKNOWN                       0x0000
#define LCDID_ILI9341                       0x9341
#define LCDID_ST7789V                       0x8552

#define LINE(x)                             ((x) * (((FONT_SelectTypeDef *)LCD_GetFont())->Height))
#define LINEY(x)                            ((x) * (((FONT_SelectTypeDef *)LCD_GetFont())->Width))

 /******************************* ILI9341 ʾ EXMC  ***************************/
//EXMC_Bank3_NORSRAMLCDĵַ
#define      EXMC_Addr_ILI9341_CMD          ((uint32_t) 0x68000000)

//EXMC_Bank3_NORSRAMLCDݲĵַ      
#define      EXMC_Addr_ILI9341_DATA         ((uint32_t) 0x68000002)

//λ A2ַ=PC1
#define      ILI9341_RST_PORT               GPIOC
#define      ILI9341_RST_PIN                GPIO_PIN_1

// A4ַ=PC3
#define      ILI9341_BK_PORT                GPIOC
#define      ILI9341_BK_PIN                 GPIO_PIN_3

/*Aַź*/    
#define EXMC_A0_GPIO_PORT                   GPIOB
#define EXMC_A0_GPIO_PIN                    GPIO_PIN_15

/*D ź*/
#define EXMC_D0_GPIO_PORT                   GPIOD
#define EXMC_D0_GPIO_PIN                    GPIO_PIN_14

#define EXMC_D1_GPIO_PORT                   GPIOD
#define EXMC_D1_GPIO_PIN                    GPIO_PIN_15

#define EXMC_D2_GPIO_PORT                   GPIOD
#define EXMC_D2_GPIO_PIN                    GPIO_PIN_0

#define EXMC_D3_GPIO_PORT                   GPIOD
#define EXMC_D3_GPIO_PIN                    GPIO_PIN_1

#define EXMC_D4_GPIO_PORT                   GPIOE
#define EXMC_D4_GPIO_PIN                    GPIO_PIN_7

#define EXMC_D5_GPIO_PORT                   GPIOE
#define EXMC_D5_GPIO_PIN                    GPIO_PIN_8

#define EXMC_D6_GPIO_PORT                   GPIOE
#define EXMC_D6_GPIO_PIN                    GPIO_PIN_9

#define EXMC_D7_GPIO_PORT                   GPIOE
#define EXMC_D7_GPIO_PIN                    GPIO_PIN_10

#define EXMC_D8_GPIO_PORT                   GPIOE
#define EXMC_D8_GPIO_PIN                    GPIO_PIN_11

#define EXMC_D9_GPIO_PORT                   GPIOE
#define EXMC_D9_GPIO_PIN                    GPIO_PIN_12

#define EXMC_D10_GPIO_PORT                  GPIOE
#define EXMC_D10_GPIO_PIN                   GPIO_PIN_13

#define EXMC_D11_GPIO_PORT                  GPIOE
#define EXMC_D11_GPIO_PIN                   GPIO_PIN_14

#define EXMC_D12_GPIO_PORT                  GPIOE
#define EXMC_D12_GPIO_PIN                   GPIO_PIN_15

#define EXMC_D13_GPIO_PORT                  GPIOD
#define EXMC_D13_GPIO_PIN                   GPIO_PIN_8

#define EXMC_D14_GPIO_PORT                  GPIOD
#define EXMC_D14_GPIO_PIN                   GPIO_PIN_9

#define EXMC_D15_GPIO_PORT                  GPIOD
#define EXMC_D15_GPIO_PIN                   GPIO_PIN_10


/*ź*/  
/*CSƬѡ*/
/*NE3 ,ӦĻַ0x68000000*/
#define EXMC_LCD_GPIO_PORT                  GPIOB
#define EXMC_LCD_GPIO_PIN                   GPIO_PIN_2

/*WEдʹ*/
#define EXMC_WE_GPIO_PORT                   GPIOD
#define EXMC_WE_GPIO_PIN                    GPIO_PIN_5

/*OEʹ*/
#define EXMC_OE_GPIO_PORT                   GPIOD
#define EXMC_OE_GPIO_PIN                    GPIO_PIN_4

/*UB*/
#define EXMC_UDQM_GPIO_PORT                 GPIOE
#define EXMC_UDQM_GPIO_PIN                  GPIO_PIN_1

/*LB*/
#define EXMC_LDQM_GPIO_PORT                 GPIOE
#define EXMC_LDQM_GPIO_PIN                  GPIO_PIN_0

/*NADV*/
#define EXMC_NADV_GPIO_PORT                 GPIOB
#define EXMC_NADV_GPIO_PIN                  GPIO_PIN_7

/*EXMC_CLK*/
#define EXMC_CLK_GPIO_PORT                  GPIOD
#define EXMC_CLK_GPIO_PIN                   GPIO_PIN_3

/*EXMC_NWATI*/
#define EXMC_NWATI_GPIO_PORT                GPIOD
#define EXMC_NWATI_GPIO_PIN                 GPIO_PIN_6



/*************************************** Ԥ ******************************************/
#define      DEBUG_DELAY()    

/***************************** ILI934 ʾʼ ***************************/
#define ILI9341_DispWindow_X_Star           0       //ʼX
#define ILI9341_DispWindow_Y_Star           0       //ʼY

#define ILI9341_LESS_PIXEL                  240     //Һ϶̷ؿ
#define ILI9341_MORE_PIXEL                  320     //Һϳؿ

//Һɨ跽仯XYؿ
//ILI9341_GramScan÷ʱԶ
extern uint16_t glcdXLength,glcdYLength; 

//Һɨģʽ
//ѡֵΪ0-7
extern uint8_t glcdScanMode;

/*******************************  ILI934 ʾɫ ********************************/
#define BACKGROUND                          BLACK       //Ĭϱɫ
#define WHITE                               0xFFFF      //ɫ
#define BLACK                               0x0000      //ɫ 
#define GREY                                0xF7DE      //ɫ 
#define BLUE                                0x001F      //ɫ 
#define BLUE2                               0x051F      //ǳɫ 
#define RED                                 0xF800      //ɫ 
#define MAGENTA                             0xF81F      //ɫɫ 
#define GREEN                               0x07E0      //ɫ 
#define CYAN                                0x7FFF      //ɫɫ 
#define YELLOW                              0xFFE0      //ɫ 
#define BRED                                0xF81F      //ɫ
#define GRED                                0xFFE0      //ɫ
#define GBLUE                               0x07FF      //ɫ



/*******************************  ILI934  ********************************/
#define CMD_SetCoordinateX                  0x2A        //X
#define CMD_SetCoordinateY                  0x2B        //Y
#define CMD_SetPixel                        0x2C        //


void APP_LCD8080_Test(void);


#endif /* __APP_H */







