
/******************************************************************************
*@file  : main.c
*@brief : main program
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h" 
#include "app.h"   

void get_reset_source(void);


/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
	HAL_Init();  
    SystemClock_Config();    
    
    BSP_UART_Init();  
	
	printfS("\r\n\r\n****************************************************************************************************\r\n");
	printfS("MCU is running %s %s \n", __DATE__, __TIME__);
	

	printfS("HCK: %u\r\n", HAL_RCC_GetHCLKFreq());
	printfS("PCLK1: %u\r\n", HAL_RCC_GetPCLK1Freq());
	printfS("PCLK2: %u\r\n", HAL_RCC_GetPCLK2Freq());
    printfS("\r\n");
	
    APP_LCD8080_Test();
    
    
    while(1)
    {
    
    }
}


