
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   




void HAL_EXMC_MspInit(EXMC_HandleTypeDef *hexmc)
{
    GPIO_InitTypeDef GPIO_Init_Norflash;
    /* Enable EXMC clock */
    __HAL_RCC_EXMC_CLK_ENABLE();

    /* Enable GPIOs clock */
    __HAL_RCC_GPIOA_CLK_ENABLE();
    __HAL_RCC_GPIOB_CLK_ENABLE();
    __HAL_RCC_GPIOC_CLK_ENABLE();
    __HAL_RCC_GPIOD_CLK_ENABLE();
    __HAL_RCC_GPIOE_CLK_ENABLE();
    __HAL_RCC_GPIOF_CLK_ENABLE();

    /*-- GPIO  -----------------------------------------------------*/

    /* ͨ GPIO  */
    GPIO_Init_Norflash.Mode  = GPIO_MODE_AF_PP;       //Ϊù
    GPIO_Init_Norflash.Alternate = GPIO_FUNCTION_10;  
    GPIO_Init_Norflash.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_Init_Norflash.Pull = GPIO_PULLUP;   

    /*Aַź */
    GPIO_Init_Norflash.Pin = EXMC_A0_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A0_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A1_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A1_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A2_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A2_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A3_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A3_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A4_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A4_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A5_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A5_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A6_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A6_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A7_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A7_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A8_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A8_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A9_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A9_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A10_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A10_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A11_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A11_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A12_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A12_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A13_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A13_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A14_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A14_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A15_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A15_GPIO_PORT, &GPIO_Init_Norflash);	

    GPIO_Init_Norflash.Pin = EXMC_A16_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A16_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_A17_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_A17_GPIO_PORT, &GPIO_Init_Norflash);
  

    /*DQź */
    GPIO_Init_Norflash.Pin = EXMC_D0_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D0_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D1_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D1_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D2_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D2_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D3_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D3_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D4_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D4_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D5_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D5_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D6_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D6_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D7_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D7_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D8_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D8_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D9_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D9_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D10_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D10_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D11_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D11_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D12_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D12_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D13_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D13_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D14_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D14_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_D15_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_D15_GPIO_PORT, &GPIO_Init_Norflash);

    /*ź*/
    GPIO_Init_Norflash.Pin = EXMC_NORFLASH_CS_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_NORFLASH_CS_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_WE_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_WE_GPIO_PORT, &GPIO_Init_Norflash);

    GPIO_Init_Norflash.Pin = EXMC_OE_GPIO_PIN; 
    HAL_GPIO_Init(EXMC_OE_GPIO_PORT, &GPIO_Init_Norflash);    

}

/******************************************************************************
* @brief : EXMC Norflash initialization.
* @param : None
* @return: none
******************************************************************************/
void EXMC_Norflash_Init(void)
{
    EXMC_HandleTypeDef hnorflash;
    hnorflash.Instance                    = EXMC;
    hnorflash.Instance_EX                 = EXMC_Ex;
    hnorflash.Init.NSBank                 = EXMC_NORSRAM_BANK4;//use CS4 controlAddr=0x6C000000
    hnorflash.Init.DataAddressMux         = EXMC_DATA_ADDRESS_MUX_DISABLE;
    hnorflash.Init.MemoryType             = EXMC_MEMORY_TYPE_NOR;
    hnorflash.Init.MemoryDataWidth        = EXMC_NORSRAM_MEM_BUS_WIDTH_16;
    hnorflash.Init.BurstAccessMode        = EXMC_BURST_ACCESS_MODE_DISABLE;
    hnorflash.Init.NwaitSignalPolarity    = EXMC_WAIT_SIGNAL_POLARITY_LOW;
    hnorflash.Init.WrapMode               = EXMC_WRAP_MODE_DISABLE;
    hnorflash.Init.SynchronousNwaitCfg    = EXMC_WAIT_TIMING_BEFORE_WS;
    hnorflash.Init.WriteEN                = EXMC_WRITE_ENABLE;
    hnorflash.Init.NwaitEN                = EXMC_WAIT_SIGNAL_DISABLE;
    hnorflash.Init.ExtendedMode           = EXMC_EXTENDED_MODE_DISABLE;
    hnorflash.Init.AsynchronousWait       = EXMC_ASYNCHRONOUS_WAIT_DISABLE;
    hnorflash.Init.WriteMode              = EXMC_WRITE_BURST_DISABLE;
    hnorflash.Init.PageSize               = EXMC_SNCTLX_CPS_0;  

    /* NOR device configuration */ 
    //HCLK = 120MHZ, 1/120M = 8.3ns        
    hnorflash.Timing.AddressSetupTime       = 0;
    hnorflash.Timing.AddressHoldTime        = 4;
    hnorflash.Timing.DataSetupTime          = 4;
    hnorflash.Timing.BusTurnAroundDuration  = 0;
    hnorflash.Timing.CLKDivision            = 0;
    hnorflash.Timing.DataLatency            = 0;
    hnorflash.Timing.AccessMode             = EXMC_ACCESS_MODE_B;//norflash

    HAL_EXMC_Init(&hnorflash);
}



/******************************************************************************
* @brief : Reads NOR memory's Manufacturer and Device Code.
* @param : NOR_ID: pointer to a NOR_IDTypeDef structure which will hold
*                  the Manufacturer and Device Code.
* @return: none
******************************************************************************/
void EXMC_NOR_ReadID(NOR_IDTypeDef* NOR_ID)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x0090);

    NOR_ID->Manufacturer_Code = *(vu16 *) ADDR_SHIFT(0x0000);
    NOR_ID->Device_Code1 = *(vu16 *) ADDR_SHIFT(0x0001);
    NOR_ID->Device_Code2 = *(vu16 *) ADDR_SHIFT(0x000E);
    NOR_ID->Device_Code3 = *(vu16 *) ADDR_SHIFT(0x000F);
}


/******************************************************************************
* @brief : Returns the NOR operation status.
* @param : NOR_ID: Timeout: NOR progamming Timeout.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_GetStatus(uint32_t Timeout)
{ 
    uint32_t index=0;
    uint16_t val1 = 0x00, val2 = 0x00;
    NOR_StatusTypeDef status = NOR_ONGOING; 
    uint32_t timeout = Timeout;
    /* Poll on NOR memory Ready/Busy signal ------------------------------------*/
    /* Get the NOR memory operation status -------------------------------------*/
    while((Timeout != 0x00) && (status != NOR_SUCCESS))
    {
        Timeout--;
        /* Read DQ6 and DQ5 */
        val1 = *(volatile uint16_t *)(EXMC_BANK_NORFLASH);
        val2 = *(volatile uint16_t *)(EXMC_BANK_NORFLASH);
        /* If DQ6 did not toggle between the two reads then return NOR_Success */
        if((val1 & NOR_MASK_STATUS_DQ6) == (val2 & NOR_MASK_STATUS_DQ6)) 
        {
            return NOR_SUCCESS;
        }
        val1 = *(vu16 *)(EXMC_BANK_NORFLASH);
        val2 = *(vu16 *)(EXMC_BANK_NORFLASH);

        if((val1 & NOR_MASK_STATUS_DQ6) == (val2 & NOR_MASK_STATUS_DQ6)) 
        {
            return NOR_SUCCESS;
        }
    }
    if(Timeout == 0x00)
    {
        status = NOR_TIMEOUT;
        printfS("Timeout\r\n");
    }

    /* Return the operation status */
    return (status);
}

/******************************************************************************
* @brief : Erases the specified Nor memory block.
* @param : BlockAddr: address of the block to erase.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_EraseBlock(uint32_t BlockAddr)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x0080);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE((EXMC_BANK_NORFLASH + BlockAddr), 0x50);

    return (EXMC_NOR_GetStatus(BLOCKERASETIMEOUT));
}

/******************************************************************************
* @brief : Erases the entire chip.
* @param : None.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_EraseChip(void)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x0080);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x0010);

    return (EXMC_NOR_GetStatus(CHIPERASETIMEOUT));
}

/******************************************************************************
* @brief : Writes a half-word to the NOR memory.
* @param : WriteAddr : NOR memory internal address to write to.
* @param : Data : Data to write.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_WriteHalfWord(uint32_t WriteAddr, uint16_t Data)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00A0);
    NOR_WRITE((EXMC_BANK_NORFLASH + WriteAddr), Data);

    return (EXMC_NOR_GetStatus(PROGRAMTIMEOUT));
}

/******************************************************************************
* @brief : Writes a Byte to the NOR memory.
* @param : WriteAddr : NOR memory internal address to write to.
* @param : Data : Data to write.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_WriteByte(uint32_t WriteAddr, uint8_t Data)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00A0);
    NOR_WRITE((EXMC_BANK_NORFLASH + WriteAddr), Data);

    return (EXMC_NOR_GetStatus(PROGRAMTIMEOUT));
}

/******************************************************************************
* @brief : Writes a half-word buffer to the EXMC NOR memory. 
* @param : pBuffer : pointer to buffer. 
* @param : WriteAddr : NOR memory internal address from which the data will be written.
* @param : NumHalfwordToWrite : number of Half words to write.
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_WriteBuffer(uint16_t* pBuffer, uint32_t WriteAddr, uint32_t NumHalfwordToWrite)
{
    NOR_StatusTypeDef status = NOR_ONGOING;

    do
    {
        /* Transfer data to the memory */
        status = EXMC_NOR_WriteHalfWord(WriteAddr, *pBuffer++);
        WriteAddr = WriteAddr + 2;
        NumHalfwordToWrite--;
    }
    while((status == NOR_SUCCESS) && (NumHalfwordToWrite != 0));

    return (status); 
}

/******************************************************************************
* @brief : Writes a half-word buffer to the EXMC NOR memory. This function 
*           must be used only with S29GL128P NOR memory.
* @param : pBuffer : pointer to buffer. 
* @param : WriteAddr : NOR memory internal address from which the data will be written.
* @param : NumHalfwordToWrite: number of Half words to write.
*           The maximum allowed value is 32 Half words (64 bytes).
* @return: NOR_StatusTypeDef:The returned value can be: NOR_SUCCESS, NOR_ERROR 
*                           or NOR_TIMEOUT
******************************************************************************/
NOR_StatusTypeDef EXMC_NOR_ProgramBuffer(uint16_t* pBuffer, uint32_t WriteAddr, uint32_t NumHalfwordToWrite)
{       
    uint32_t lastloadedaddress = 0x00;
    uint32_t currentaddress = 0x00;
    uint32_t endaddress = 0x00;

    /* Initialize variables */
    currentaddress = WriteAddr;
    endaddress = WriteAddr + NumHalfwordToWrite - 1;
    lastloadedaddress = WriteAddr;

    /* Issue unlock command sequence */
    NOR_WRITE(ADDR_SHIFT(0x005555), 0x00AA);

    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055); 

    /* Write Write Buffer Load Command */
    NOR_WRITE(ADDR_SHIFT(WriteAddr), 0x0025);
    NOR_WRITE(ADDR_SHIFT(WriteAddr), (NumHalfwordToWrite - 1));

    /* Load Data into NOR Buffer */
    while(currentaddress <= endaddress)
    {
        /* Store last loaded address & data value (for polling) */
        lastloadedaddress = currentaddress;

        NOR_WRITE(ADDR_SHIFT(currentaddress), *pBuffer++);
        currentaddress += 1; 
    }

    NOR_WRITE(ADDR_SHIFT(lastloadedaddress), 0x29);

    return(EXMC_NOR_GetStatus(PROGRAMTIMEOUT));
}

/******************************************************************************
* @brief : Reads a half-word from the NOR memory. 
* @param : ReadAddr : NOR memory internal address to read from.
* @return: Half-word read from the NOR memory.
******************************************************************************/
uint16_t EXMC_NOR_ReadHalfWord(uint32_t ReadAddr)
{
    NOR_WRITE(ADDR_SHIFT(0x005555), 0x00AA); 
    NOR_WRITE(ADDR_SHIFT(0x002AAA), 0x0055);  
    NOR_WRITE((EXMC_BANK_NORFLASH + ReadAddr), 0x00F0 );

    return (*(vu16 *)((EXMC_BANK_NORFLASH + ReadAddr)));
}
  
/******************************************************************************
* @brief : Reads a word from the NOR memory. 
* @param : ReadAddr : NOR memory internal address to read from.
* @return: word read from the NOR memory.
******************************************************************************/  
uint32_t EXMC_NOR_ReadWord(uint32_t ReadAddr)
{
    NOR_WRITE(ADDR_SHIFT(0x005555), 0x00AA); 
    NOR_WRITE(ADDR_SHIFT(0x002AAA), 0x0055);  
    NOR_WRITE((EXMC_BANK_NORFLASH + ReadAddr), 0x00F0 );

    return (*(vu32 *)((EXMC_BANK_NORFLASH + ReadAddr)));
}

/******************************************************************************
* @brief : Reads a block of data from the EXMC NOR memory.
* @param : pBuffer : pointer to the buffer that receives the data read 
*                    from the NOR memory.
* @param : ReadAddr : NOR memory internal address to read from.
* @param : NumHalfwordToRead : number of Half word to read.
* @return: None.
******************************************************************************/ 
void EXMC_NOR_ReadBuffer(uint16_t* pBuffer, uint32_t ReadAddr, uint32_t NumHalfwordToRead)
{
    NOR_WRITE(ADDR_SHIFT(0x05555), 0x00AA);
    NOR_WRITE(ADDR_SHIFT(0x02AAA), 0x0055);
    NOR_WRITE((EXMC_BANK_NORFLASH + ReadAddr), 0x00F0);

    for(; NumHalfwordToRead != 0x00; NumHalfwordToRead--) /* while there is data to read */
    {
        /* Read a Halfword from the NOR */
        *pBuffer++ = *(vu16 *)((EXMC_BANK_NORFLASH + ReadAddr));
        ReadAddr = ReadAddr + 2; 
    }  
}

/******************************************************************************
* @brief : Returns the NOR memory to Read mode.
* @param : None.
* @return: None.
******************************************************************************/ 
NOR_StatusTypeDef EXMC_NOR_ReturnToReadMode(void)
{
    NOR_WRITE(EXMC_BANK_NORFLASH, 0x00F0);
    return (NOR_SUCCESS);
}

/******************************************************************************
* @brief : Returns the NOR memory to Read mode and resets the errors in
*                  the NOR memory Status Register.
* @param : None.
* @return: NOR_SUCCESS.
******************************************************************************/ 
NOR_StatusTypeDef EXMC_NOR_Reset(void)
{
    NOR_WRITE(ADDR_SHIFT(0x005555), 0x00AA); 
    NOR_WRITE(ADDR_SHIFT(0x002AAA), 0x0055); 
    NOR_WRITE(EXMC_BANK_NORFLASH, 0x00F0);

    return (NOR_SUCCESS);
}


void Nor_Write_Read_Test()//16λд
{
    uint32_t temp=0, i=0, j=0, errortime=0;

    EXMC_NOR_EraseBlock(0);

    for(i=0;i<SST39VF400A_BLOCK_SIZE/2;i++)
    {
        j++;
        if(j>0xffff)
        {
            j=0;
        }
        EXMC_NOR_WriteHalfWord(2*i, j); 
    }


    j=0;
    for(i=0;i<SST39VF400A_BLOCK_SIZE/2;i++)
    {
        j++;
        if(j>0xffff)
        {
            j=0;
        }
        temp = EXMC_NOR_ReadHalfWord(2*i);
        if(temp!=j)
        {    
            errortime++;
            printfS("Addr=%0.8x,W=%0.8x,R=%0.8x,\r\n",2*i,j,temp); 
        }
    }

    if(errortime==0)
    {
        printfS("Nor_Write_Read_Test Pass!\r\n"); 
    }
    else
    {
        printfS("Nor_Write_Read_TestError!\r\n"); 
    }
}


void APP_Norflash_Test(void)
{  
    printfS("Start Norflash test!\r\n");  
    NOR_IDTypeDef NOR_ID;
    
    EXMC_Norflash_Init();
    EXMC_NOR_ReadID(&NOR_ID);
    printfS("Manufacturer_Code = 0x%04x\r\n", NOR_ID.Manufacturer_Code);
    printfS("Device_Code1 = 0x%04x\r\n", NOR_ID.Device_Code1);
    printfS("Device_Code2 = 0x%04x\r\n", NOR_ID.Device_Code2);
    printfS("Device_Code3 = 0x%04x\r\n", NOR_ID.Device_Code3);
    EXMC_NOR_ReturnToReadMode();
    Nor_Write_Read_Test();
    printf("Nor test End!\r\n");  
}




