
/******************************************************************************
*@file  : app.h
*@brief : application
******************************************************************************/

#ifndef __APP_H
#define __APP_H

#include "hal.h"

#define SST39VF400A_BLOCK_SIZE              0x20000  //NOR: 32 KWord=32*1024*4=0x20000


#define EXMC_BANK_NORFLASH                  ((uint32_t)(0x6C000000))  

#define ADDR_SHIFT(A)                       (EXMC_BANK_NORFLASH + (2 * (A)))
#define NOR_WRITE(Address, Data)            (*(volatile uint16_t *)(Address) = (Data))

#define BLOCKERASETIMEOUT                   ((uint32_t)0x000A0000)
#define CHIPERASETIMEOUT                    ((uint32_t)0x30000000) 
#define PROGRAMTIMEOUT                      ((uint32_t)0x00001400)


/*Aַź*/    
#define EXMC_A0_GPIO_PORT                   GPIOF
#define EXMC_A0_GPIO_PIN                    GPIO_PIN_2

#define EXMC_A1_GPIO_PORT                   GPIOC
#define EXMC_A1_GPIO_PIN                    GPIO_PIN_0

#define EXMC_A2_GPIO_PORT                   GPIOC
#define EXMC_A2_GPIO_PIN                    GPIO_PIN_1

#define EXMC_A3_GPIO_PORT                   GPIOC
#define EXMC_A3_GPIO_PIN                    GPIO_PIN_2

#define EXMC_A4_GPIO_PORT                   GPIOC
#define EXMC_A4_GPIO_PIN                    GPIO_PIN_3

#define EXMC_A5_GPIO_PORT                   GPIOC
#define EXMC_A5_GPIO_PIN                    GPIO_PIN_4

#define EXMC_A6_GPIO_PORT                   GPIOC
#define EXMC_A6_GPIO_PIN                    GPIO_PIN_5

#define EXMC_A7_GPIO_PORT                   GPIOC
#define EXMC_A7_GPIO_PIN                    GPIO_PIN_6

#define EXMC_A8_GPIO_PORT                   GPIOC
#define EXMC_A8_GPIO_PIN                    GPIO_PIN_7

#define EXMC_A9_GPIO_PORT                   GPIOC
#define EXMC_A9_GPIO_PIN                    GPIO_PIN_8

#define EXMC_A10_GPIO_PORT                  GPIOC
#define EXMC_A10_GPIO_PIN                   GPIO_PIN_9

#define EXMC_A11_GPIO_PORT                  GPIOC
#define EXMC_A11_GPIO_PIN                   GPIO_PIN_12

#define EXMC_A12_GPIO_PORT                  GPIOC
#define EXMC_A12_GPIO_PIN                   GPIO_PIN_11

#define EXMC_A13_GPIO_PORT                  GPIOC
#define EXMC_A13_GPIO_PIN                   GPIO_PIN_10

#define EXMC_A14_GPIO_PORT                  GPIOF
#define EXMC_A14_GPIO_PIN                   GPIO_PIN_4

#define EXMC_A15_GPIO_PORT                  GPIOD
#define EXMC_A15_GPIO_PIN                   GPIO_PIN_2

#define EXMC_A16_GPIO_PORT                  GPIOD
#define EXMC_A16_GPIO_PIN                   GPIO_PIN_11

#define EXMC_A17_GPIO_PORT                  GPIOD
#define EXMC_A17_GPIO_PIN                   GPIO_PIN_12

/*D ź*/
#define EXMC_D0_GPIO_PORT                   GPIOD
#define EXMC_D0_GPIO_PIN                    GPIO_PIN_14

#define EXMC_D1_GPIO_PORT                   GPIOD
#define EXMC_D1_GPIO_PIN                    GPIO_PIN_15

#define EXMC_D2_GPIO_PORT                   GPIOD
#define EXMC_D2_GPIO_PIN                    GPIO_PIN_0

#define EXMC_D3_GPIO_PORT                   GPIOD
#define EXMC_D3_GPIO_PIN                    GPIO_PIN_1

#define EXMC_D4_GPIO_PORT                   GPIOE
#define EXMC_D4_GPIO_PIN                    GPIO_PIN_7

#define EXMC_D5_GPIO_PORT                   GPIOE
#define EXMC_D5_GPIO_PIN                    GPIO_PIN_8

#define EXMC_D6_GPIO_PORT                   GPIOE
#define EXMC_D6_GPIO_PIN                    GPIO_PIN_9

#define EXMC_D7_GPIO_PORT                   GPIOE
#define EXMC_D7_GPIO_PIN                    GPIO_PIN_10

#define EXMC_D8_GPIO_PORT                   GPIOE
#define EXMC_D8_GPIO_PIN                    GPIO_PIN_11

#define EXMC_D9_GPIO_PORT                   GPIOE
#define EXMC_D9_GPIO_PIN                    GPIO_PIN_12

#define EXMC_D10_GPIO_PORT                  GPIOE
#define EXMC_D10_GPIO_PIN                   GPIO_PIN_13

#define EXMC_D11_GPIO_PORT                  GPIOE
#define EXMC_D11_GPIO_PIN                   GPIO_PIN_14

#define EXMC_D12_GPIO_PORT                  GPIOE
#define EXMC_D12_GPIO_PIN                   GPIO_PIN_15

#define EXMC_D13_GPIO_PORT                  GPIOD
#define EXMC_D13_GPIO_PIN                   GPIO_PIN_8

#define EXMC_D14_GPIO_PORT                  GPIOD
#define EXMC_D14_GPIO_PIN                   GPIO_PIN_9

#define EXMC_D15_GPIO_PORT                  GPIOD
#define EXMC_D15_GPIO_PIN                   GPIO_PIN_10


/*ź*/  
/*CSƬѡ*/
/*NE4 ,ӦĻַ0x6C000000*/
#define EXMC_NORFLASH_CS_GPIO_PORT          GPIOB
#define EXMC_NORFLASH_CS_GPIO_PIN           GPIO_PIN_13

/*WEдʹ*/
#define EXMC_WE_GPIO_PORT                   GPIOD
#define EXMC_WE_GPIO_PIN                    GPIO_PIN_5

/*OEʹ*/
#define EXMC_OE_GPIO_PORT                   GPIOD
#define EXMC_OE_GPIO_PIN                    GPIO_PIN_4

/* Mask on NOR STATUS REGISTER */
#define NOR_MASK_STATUS_DQ6                 (uint16_t)0x0040
#define NOR_MASK_STATUS_DQ7                 (uint16_t)0x0080


typedef enum
{
    NOR_SUCCESS  = 0U,
    NOR_ONGOING,
    NOR_ERROR,
    NOR_TIMEOUT
}NOR_StatusTypeDef;

typedef struct
{
    uint16_t Manufacturer_Code;  

    uint16_t Device_Code1;

    uint16_t Device_Code2;

    uint16_t Device_Code3;      
}NOR_IDTypeDef;





void APP_Norflash_Test(void);


#endif /* __APP_H */







