/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/
#include "hal.h"

void HAL_I2C_MspInit(I2C_HandleTypeDef *hi2c)
{    
    /* For Example */
    GPIO_InitTypeDef GPIO_Handle; 
    
    /* I2C1 */
    if (hi2c->Instance == I2C1)
    {
        /* Enable Clock */
        __HAL_RCC_I2C1_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();

        /* I2C1 SDA  PB7 */
        /* I2C1 SCL  PB6 */
        GPIO_Handle.Pin            = GPIO_PIN_6 | GPIO_PIN_7;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_PULLUP;
		GPIO_Handle.Drive          = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_5;
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
        
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(I2C1_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(I2C1_IRQn);
        
        printfS("I2C PINs selected:\r\n");
        printfS("I2C SCL:PB6\r\n");
        printfS("I2C SDA:PB7\r\n\r\n");
        
    }
    /* I2C2 */
    else if (hi2c->Instance == I2C2) 
    {
        __HAL_RCC_I2C2_CLK_ENABLE(); 
        __HAL_RCC_GPIOB_CLK_ENABLE();

        /* I2C2 SCL  PB10 */
        /* I2C2 SDA  PB11 */
		GPIO_Handle.Pin            = GPIO_PIN_10 | GPIO_PIN_11;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_PULLUP;
		GPIO_Handle.Drive          = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_5;
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
						
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(I2C2_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(I2C2_IRQn);
        
        printfS("I2C PINs selected:\r\n");
        printfS("I2C SCL:PB10\r\n");
        printfS("I2C SDA:PB11\r\n\r\n");
    }
}