
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "main.h"
#include "acm32g103_ww8978.h"

DMA_HandleTypeDef DMA1CH0_Tx;

/******************************************************************************
*@brief : Initialize the I2S MSP.
*@param : hi2s: pointer to a I2S_HandleTypeDef structure that contains
*               the configuration information for I2S module.
*@return: None
******************************************************************************/
void HAL_I2S_MspInit(I2S_HandleTypeDef *hi2s)
{
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    
    assert_param(hi2s != NULL);
    assert_param(IS_I2S_INSTANCE(hi2s->Instance));
    
    if (hi2s->Instance == I2S1)
    {
        __HAL_RCC_I2S1_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();
        
        // PB4=MCK  PB0=WS PB3=CK PB5=SD
        GPIO_InitStruct.Pin       = GPIO_PIN_5 | GPIO_PIN_4 | GPIO_PIN_3 | GPIO_PIN_0;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_7;

        HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
        
        __HAL_RCC_I2S1_RESET();
    }
    
    __HAL_RCC_DMA1_CLK_ENABLE();

    /* Configure the DMA */
    /* Configure the DMA handler for Transmission process */
    DMA1CH0_Tx.Instance          = DMA1_Channel0;
    DMA1CH0_Tx.Init.ReqID        = DMA1_REQ37_I2S1_TX;
    DMA1CH0_Tx.Init.DataFlow     = DMA_DATAFLOW_M2P;
    DMA1CH0_Tx.Init.SrcInc       = DMA_SRCINC_ENABLE;
    DMA1CH0_Tx.Init.DestInc      = DMA_DESTINC_DISABLE;
    DMA1CH0_Tx.Init.SrcWidth     = DMA_SRCWIDTH_WORD;
    DMA1CH0_Tx.Init.DestWidth    = DMA_DESTWIDTH_WORD;
    DMA1CH0_Tx.Init.SrcBurst     = DMA_SRCBURST_1;
    DMA1CH0_Tx.Init.DestBurst    = DMA_DESTBURST_1;
    DMA1CH0_Tx.Init.Mode         = DMA_MODE_NORMAL;

    HAL_DMA_Init(&DMA1CH0_Tx);

    /* Associate the initialized DMA handle to the UART handle */
    __HAL_LINKDMA(&I2S1_Handle, hdmatx, DMA1CH0_Tx);
    
    NVIC_ClearPendingIRQ(I2S1_IRQn);
    NVIC_SetPriority(I2S1_IRQn, 0x00);
    NVIC_EnableIRQ(I2S1_IRQn);
    
    NVIC_ClearPendingIRQ(DMA1_IRQn);
    NVIC_SetPriority(DMA1_IRQn, 0x00);
    NVIC_EnableIRQ(DMA1_IRQn);
    
}

/******************************************************************************
*@brief : DeInitialize the I2S MSP.
*@param : hi2s: pointer to a I2S_HandleTypeDef structure that contains
*               the configuration information for I2S module.
*@return: None
******************************************************************************/
void HAL_I2S_MspDeInit(I2S_HandleTypeDef *hi2s)
{
    assert_param(hi2s != NULL);
    assert_param(IS_I2S_INSTANCE(hi2s->Instance));
    
    if (hi2s->Instance == I2S1)
    {
        __HAL_RCC_I2S1_RESET();
        
        __HAL_RCC_I2S1_CLK_DISABLE();
        
        HAL_GPIO_DeInit(GPIOB, GPIO_PIN_5 | GPIO_PIN_4 | GPIO_PIN_3 | GPIO_PIN_0);
    }
}


