
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 
#include "acm32g103_ww8978.h"   



/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    RCC_OscInitTypeDef      RCC_OscInitStruct = {0};
    
    printfS("LPTIM1 Counter Demo\r\n");
    printfS("\r\n");
    
	BSP_LED_Init();
	
	BSP_LED_On();
	HAL_Delay(500);
	BSP_LED_Off();
	HAL_Delay(500);
	BSP_LED_On();
    
    printfS("WW8978 Init \r\n");
    if (BSP_WW8978_Init() != HAL_OK)
    {
        printfS("WW8978 Init failed\r\n");
        while (1);
    }
    
    printfS("Loop audio\r\n");
    while (1)
    {
        
        BSP_WM8978_Palyer(0);
        HAL_Delay(500);
        BSP_WM8978_Palyer(1);
        HAL_Delay(500);
        BSP_WM8978_Palyer(2);
        HAL_Delay(500);
    }
}


