
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   


IWDT_HandleTypeDef IWDT_Handle;


/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t reload;
    uint32_t freq;
    uint32_t resetTime;
    RCC_OscInitTypeDef      RCC_OscInitStruct = {0};
    
	BSP_LED_Init();
	
    BSP_LED_On();
    HAL_Delay(2000);
    
	/* ʹܣRC32K */
    RCC_OscInitStruct.OscType = RCC_OSCTYPE_RC32K;
    RCC_OscInitStruct.RC32K = ENABLE;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
    {
        while (1);
    }  
	
	/* ʹܣIWDTλϵͳλ */
	__HAL_RCC_IWDTRSTTOSYSRST_ENABLE();
    
    __HAL_RCC_EXTI_CLK_ENABLE();
    
    reload = 4000;
    
    /* IWDT */
    
    IWDT_Handle.Instance = IWDT;
    IWDT_Handle.Init.Prescaler  = IWDT_CLOCK_PRESCALER_4;
    IWDT_Handle.Init.Reload     = reload;
    IWDT_Handle.Init.Window     = reload;
    IWDT_Handle.Init.Wakeup     = reload >> 1;
    IWDT_Handle.Init.WakeupMode = IWDT_WAKEUP_MODE_IT;
    
    HAL_IWDT_Init(&IWDT_Handle);

    /* ʹIWDTж */
    
	NVIC_ClearPendingIRQ(IWDT_WAKEUP_IRQn);
	NVIC_SetPriority(IWDT_WAKEUP_IRQn, 0x00);
	NVIC_EnableIRQ(IWDT_WAKEUP_IRQn);
    
    freq = HAL_RCC_GetRC32KVal() / 4;
    resetTime = reload * 1000 / freq;
    
    HAL_IWDT_Refresh(&IWDT_Handle);
    
    while(1)
    {
        /* ڸλʱ䵽ǰ50msˢIWDT */
        HAL_Delay(resetTime - 50);
        
        HAL_IWDT_Refresh(&IWDT_Handle);
    };
}

void HAL_IWDT_Callback(IWDT_HandleTypeDef *hiwdt)
{
    /* ﻽ֵжϣл״̬ */
    BSP_LED_Toggle();
}
