
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "app.h"


void HAL_LPTIM_MspInit(LPTIM_HandleTypeDef *hlptim)
{
    __HAL_RCC_LPTIM1_CLK_ENABLE();
    
    NVIC_ClearPendingIRQ(LPTIM1_IRQn);
    NVIC_SetPriority(LPTIM1_IRQn, 0x00);
    NVIC_EnableIRQ(LPTIM1_IRQn);
    
}

void HAL_LPTIM_MspDeInit(LPTIM_HandleTypeDef *hlptim)
{
    __HAL_RCC_LPTIM1_RESET();
    
    __HAL_RCC_LPTIM1_CLK_DISABLE();
    
    NVIC_DisableIRQ(LPTIM1_IRQn);
    NVIC_ClearPendingIRQ(LPTIM1_IRQn);
    
}
