
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "app.h"


void HAL_LPTIM_MspInit(LPTIM_HandleTypeDef *hlptim)
{
    GPIO_InitTypeDef  GPIO_InitStruct;

    __HAL_RCC_LPTIM1_CLK_ENABLE();
    
    __HAL_RCC_GPIOB_CLK_ENABLE();

    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_10;

    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
    
    GPIO_InitStruct.Pin       = GPIO_PIN_7;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_6;

    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
    
    NVIC_ClearPendingIRQ(LPTIM1_IRQn);
    NVIC_SetPriority(LPTIM1_IRQn, 0x00);
    NVIC_EnableIRQ(LPTIM1_IRQn);
    
}

void HAL_LPTIM_MspDeInit(LPTIM_HandleTypeDef *hlptim)
{
    GPIO_InitTypeDef  GPIO_InitStruct;

    __HAL_RCC_LPTIM1_RESET();
    
    __HAL_RCC_LPTIM1_CLK_DISABLE();
    
    HAL_GPIO_DeInit(GPIOB, GPIO_PIN_2);
    
    NVIC_DisableIRQ(LPTIM1_IRQn);
    NVIC_ClearPendingIRQ(LPTIM1_IRQn);
    
}