
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "app.h"


void HAL_LPUART_MspInit(LPUART_HandleTypeDef *hlpuart)
{
    GPIO_InitTypeDef  GPIO_InitStruct;

    __HAL_RCC_DMA1_CLK_ENABLE();
    __HAL_RCC_DMA2_CLK_ENABLE();
    __HAL_RCC_LPUART1_CLK_ENABLE();
    __HAL_RCC_GPIOC_CLK_ENABLE();
    
    __HAL_RCC_LPUART1_RESET();

    GPIO_InitStruct.Pin       = GPIO_PIN_1 | GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;

    HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);
    
    /* Configure the DMA handler for Transmission process */
    DMA1CH0_Tx.Instance          = DMA1_Channel0;
    DMA1CH0_Tx.Init.Mode         = DMA_MODE_NORMAL;//DMA_MODE_NORMAL;
    DMA1CH0_Tx.Init.ReqID        = DMA1_REQ30_LPUART1_SEND;
    DMA1CH0_Tx.Init.DataFlow     = DMA_DATAFLOW_M2P;
    DMA1CH0_Tx.Init.SrcInc       = DMA_SRCINC_ENABLE;
    DMA1CH0_Tx.Init.DestInc      = DMA_DESTINC_DISABLE;
    DMA1CH0_Tx.Init.SrcWidth     = DMA_SRCWIDTH_BYTE;
    DMA1CH0_Tx.Init.DestWidth    = DMA_DESTWIDTH_BYTE;
    DMA1CH0_Tx.Init.SrcBurst     = DMA_SRCBURST_1;
    DMA1CH0_Tx.Init.DestBurst    = DMA_DESTBURST_1;

    HAL_DMA_Init(&DMA1CH0_Tx);

    /* Associate the initialized DMA handle to the UART handle */
    __HAL_LINKDMA(hlpuart, hdmatx, DMA1CH0_Tx);

    /* Configure the DMA handler for reception process */
    DMA2CH0_Rx.Instance          = DMA2_Channel0;
    DMA2CH0_Rx.Init.Mode         = DMA_MODE_CIRCULAR;
    DMA2CH0_Rx.Init.ReqID        = DMA2_REQ31_LPUART1_RECV;
    DMA2CH0_Rx.Init.DataFlow     = DMA_DATAFLOW_P2M;
    DMA2CH0_Rx.Init.SrcInc       = DMA_SRCINC_DISABLE;
    DMA2CH0_Rx.Init.DestInc      = DMA_DESTINC_ENABLE;
    DMA2CH0_Rx.Init.SrcWidth     = DMA_SRCWIDTH_BYTE;
    DMA2CH0_Rx.Init.DestWidth    = DMA_DESTWIDTH_BYTE;
    DMA2CH0_Rx.Init.SrcBurst     = DMA_SRCBURST_1;
    DMA2CH0_Rx.Init.DestBurst    = DMA_DESTBURST_1;

    HAL_DMA_Init(&DMA2CH0_Rx);

    /* Associate the initialized DMA handle to the the UART handle */
    __HAL_LINKDMA(hlpuart, hdmarx, DMA2CH0_Rx);

  
    NVIC_ClearPendingIRQ(LPUART1_IRQn);
    NVIC_SetPriority(LPUART1_IRQn, 0x00);
    NVIC_EnableIRQ(LPUART1_IRQn);
    
    NVIC_ClearPendingIRQ(DMA1_IRQn);
    NVIC_SetPriority(DMA1_IRQn, 0x00);
    NVIC_EnableIRQ(DMA1_IRQn);
    
    NVIC_ClearPendingIRQ(DMA2_IRQn);
    NVIC_SetPriority(DMA2_IRQn, 0x00);
    NVIC_EnableIRQ(DMA2_IRQn);
}

void HAL_LPUART_MspDeInit(LPUART_HandleTypeDef *hlpuart)
{
    __HAL_RCC_LPUART1_CLK_ENABLE();
    __HAL_RCC_LPUART1_RESET();
    __HAL_RCC_LPUART1_CLK_DISABLE();
    
    HAL_GPIO_DeInit(GPIOC, GPIO_PIN_1);
    HAL_GPIO_DeInit(GPIOC, GPIO_PIN_0);
}