
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h" 
#include "app.h"   




/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
	HAL_Init();  
    SystemClock_Config();    
    
    BSP_UART_Init();  
	
	printfS("\r\n\r\n****************************************************************************************************\r\n");
	printfS("MCU is running %s %s\n", __DATE__, __TIME__);
	
	get_reset_source();

    printfS("PMU_SR1 = 0x%08x\r\n", PMU->SR);
    PMU->STCLR = 0xffff;
    HAL_SimpleDelay(100);
    printfS("PMU_SR2 = 0x%08x\r\n", PMU->SR);

    APP_Test();
    
	while(1)
	{
    
	}
}


