
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   
#include "acm32g103_coreboard.h"


/******************************************************************************
* @brief : LVD Reset config.
* @param : none
* @return: none
******************************************************************************/
void LVD_ResetConfig(void)
{
    __HAL_RCC_PMU_CLK_ENABLE();	
    //˲4ѹ2.51V
    HAL_PMU_LvdResetEnable(PMU_LVDVOLTAGE_2V51, PMU_LVDFILTER_4SAMPLE, PMU_LVDFILTER_ENABLE);
}


/******************************************************************************
* @brief : LVD Interrupt config.
* @param : none
* @return: none
******************************************************************************/
void LVDInterruptConfig(void)
{
    __HAL_RCC_PMU_CLK_ENABLE();	
    //˲4ѹ2.51V
    HAL_PMU_LvdResetEnable(PMU_LVDVOLTAGE_2V51, PMU_LVDFILTER_4SAMPLE, PMU_LVDFILTER_ENABLE);
    HAL_SimpleDelay(100);
    //رLVDλϵͳ
    __HAL_RCC_LVDRSTTOSYSRST_DISABLE();

    //LVDж
    __HAL_RCC_EXTI_CLK_ENABLE();
    HAL_EXTI_SetConfigLine(NULL, EXTI_LINE_16, EXTI_MODE_IT_RISING);
    NVIC_ClearPendingIRQ(LVD_IRQn);
    NVIC_SetPriority(LVD_IRQn, 5);
    NVIC_EnableIRQ(LVD_IRQn);
}


/******************************************************************************
* @brief : App test.
* @param : mode: LVD mode select:stop0 or stop1 or stop2 
* @return: none
******************************************************************************/
void APP_Test(LVD_TestMode_TypeDef mode)
{
    switch (mode)
    {
        /* LVDλ */
        case LVD_RESET:
        {
            LVD_ResetConfig();           
        }
        break;
        /* LVDж */
        case LVD_INTERRUPT:
        {
            LVDInterruptConfig();
        }
        break;
        default: break; 
    }
}


