
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h" 
#include "app.h"   






/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
    uint32_t count = 0;
    uint8_t chip_id[16];
    HAL_Init(); 

    SystemClock_Config();    

    BSP_UART_Init(); 
    BSP_LED_Init();

    printfS("******************************************************************************\r\n");
    printfS("MCU Info:\r\n");
    memcpy(chip_id, (uint8_t*)0x00802d0, 8);
    printfS("Chip model: ACM32F%c%c%c%c%c%c%c%c\r\n", 
                         chip_id[3], chip_id[2], chip_id[1], chip_id[0],
                         chip_id[7], chip_id[6], chip_id[5], chip_id[4]);
    memcpy(chip_id, (uint8_t*)0x0080208, 16);
    printfS("Chip ID: %02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X%02X\r\n",
                         chip_id[0], chip_id[1], chip_id[2], chip_id[3],
                         chip_id[4], chip_id[5], chip_id[6], chip_id[7],
                         chip_id[8], chip_id[9], chip_id[10], chip_id[11],
                         chip_id[12], chip_id[13], chip_id[14], chip_id[15]);
                         
    printfS("RCC_RSR1 = 0x%08x\r\n", RCC->RSR); 
    RCC->RSR |= BIT16;
    HAL_SimpleDelay(100);
    printfS("RCC_RSR2 = 0x%08x\r\n", RCC->RSR); 
   
                         
    APP_Test(LVD_RESET);
    
	while(1)
	{
        printfS("%d ",count);
        HAL_Delay(1000);
        if(count++ > 0xFFFFFFF0)
        {
            count = 0;
        }
	}
}



