#include "acm32g103_hal_conf.h"

/*****************************************************************
@	Stop͹ģʽرEflash,Ram
@	
@	
******************************************************************/
void Enter_Stop_Ram(uint8_t mode)
{
	volatile uint32_t i;
    
    SysTick->CTRL = 0;   // disable systick        
    __set_PRIMASK(1);    // disable interrupt 
    SCB->ICSR = BIT25;   // clear systick pending bit 
    
    __HAL_RCC_PMU_CLK_ENABLE();
    
    PMU->STCLR = 0xFFFFFFFF;//Clear all wake-up flags

    PMU->CTRL0 &= ~(0xFFF << 16);
    PMU->CTRL0 |= (0x50 << 16);//STOP0/STOP1/STOP2ʱ
    //printfS("PMU->CTRL0 = 0x%08x\r\n",PMU->CTRL0); 
    if(mode != PMU_CTL0_LPMS_STOP2)
    {        
        /*ʱлRCH*/
        RCC->RC64MCR &= ~RCC_RC64MCR_RC64MDIV;
        RCC->RC64MCR |= RCC_RC64MCR_RC64MEN;
        while (!(RCC->RC64MCR & RCC_RC64MCR_RC64MRDY));

        RCC->CCR1 &= ~RCC_CCR1_SYSCLKSEL;	/* sysclk = RC64M  */
                
        /* رXTHXTL32K ʱ  */
        RCC->XTHCR &= ~(1 <<  0);     // XTH  Disable
        RCC->PLLCR &= ~(1 << 0);      //PLL Disable
        RCC->STDBYCTRL &= ~(1 << 8); //RC32K Disable
        RCC->STDBYCTRL &= ~(1 << 0); //XTL Disable
        
       /* All Clock Disable */
        RCC->CLKOCR &= ~(1ul << 31);    // Buzzer2 Disable
        RCC->CLKOCR &= ~(1ul << 23);    // Buzzer1 Disable

        RCC->APB1ENR = BIT27;//PMU
        RCC->APB2ENR = BIT4 ;//EXTI  
        
        PMU->CTRL1 &= ~0x01;//ֹLVD       
        /* STOP ģʽ¹رRC64M */
        PMU->CTRL0 |= 1 << 4;//ֹͣSTOPģʽ£RC64M Զر 
    }
    
    EXTI->PDR = EXTI_ALL_LINE_MASK;//Clear all EXTI interrupt pending 
    
    if(mode == PMU_CTL0_LPMS_STOP0)
    {          
        PMU->CTRL0 |= (0x1 << 8);//MLDO12Ϊ1.0V
        PMU->CTRL0 |= 1 << 10;//MLDOǷ͹ģʽ    
        MODIFY_REG(PMU->CTRL0, PMU_CTL0_LPMS_Msk, PMU_CTL0_LPMS_STOP0);
    }
    else if(mode == PMU_CTL0_LPMS_STOP1)
    {
        /* STOP1 ģʽ¹رLDO12*/
        PMU->CTRL0 |= (0x1 << 8);//MLDO12Ϊ1.0V
        PMU->CTRL0 |= 1 << 10;//MLDOǷ͹ģʽ            
        MODIFY_REG(PMU->CTRL0, PMU_CTL0_LPMS_Msk, PMU_CTL0_LPMS_STOP1);
    }
    else if(mode == PMU_CTL0_LPMS_STOP2)
    {
        PMU->CTRL0 |= (0x1 << 8);//MLDO12Ϊ1.0V 
        //PMU->CTRL0 |= (0x7 << 12);//LPLD12Ϊ1.2V
        /*ʱлRC32K*/
        RCC->STDBYCTRL |= (1<<8);//RC32Kʱʹ 
        RCC->CCR1 = 0x01; 
        while(0 == ((RCC->STDBYCTRL) & (1U << 9)));
        MODIFY_REG(PMU->CTRL0, PMU_CTL0_LPMS_Msk, PMU_CTL0_LPMS_STOP2);
    }        

        
    if(mode != PMU_CTL0_LPMS_STOP2)
    {
        /*Eflash sleepģʽ */
        EFC->CTRL |= 1<<12;
    }
    
    SET_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));   // Set SLEEPDEEP bit of Cortex System Control Register 
      

	/*---------------stopģʽ-----------*/
	/* Wait For Interrupt */   
    __WFI();
	
	/*---------------Ѻ-------------*/
	CLEAR_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk)); 
	
    if(mode != PMU_CTL0_LPMS_STOP2)
    {    
        /* ѺEflash˳Sleepģʽ */
        EFC->CTRL &= ~(1<<12);
        for(i = 0; i < 10 *5000; i++); //Elash˳Sleepʱ10uS
    }
    //Systick
    SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk; /* Enable SysTick IRQ and SysTick Timer */ 
    //ж               
    __set_PRIMASK(0);    // enable interrupt 
}


