
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h"

void HAL_UART_MspInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspInit can be implemented in the user file.
    */

    /* For Example */
    GPIO_InitTypeDef    GPIO_Uart = {0};
    
    if (huart->Instance == UART1) 
    {
        /* Initialization GPIO */
        /* A9:Tx  A10:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_9 | GPIO_PIN_10;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_11;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_12;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        /* Enable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART1_IRQn);
        NVIC_SetPriority(UART1_IRQn, 5);
        NVIC_EnableIRQ(UART1_IRQn);
    }
    
    if (huart->Instance == UART2) 
    {
        /* Initialization GPIO */
        /* A2:Tx  A3:Rx */
        __HAL_RCC_GPIOA_CLK_ENABLE();
        GPIO_Uart.Pin       = GPIO_PIN_2 | GPIO_PIN_3;
        GPIO_Uart.Mode      = GPIO_MODE_AF_PP;
        GPIO_Uart.Pull      = GPIO_PULLUP;
        GPIO_Uart.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_Uart.Alternate = GPIO_FUNCTION_1;
        
        HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        
        if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            GPIO_Uart.Pin = GPIO_PIN_0;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            GPIO_Uart.Pin = GPIO_PIN_1;
            
            HAL_GPIO_Init(GPIOA, &GPIO_Uart);
        }

        /* Enable Clock */
        __HAL_RCC_UART2_CLK_ENABLE();
        /* NVIC Config */
        NVIC_ClearPendingIRQ(UART2_IRQn);
        NVIC_SetPriority(UART2_IRQn, 5);
        NVIC_EnableIRQ(UART2_IRQn);
    }
}

void HAL_UART_MspDeInit(UART_HandleTypeDef *huart)
{
    /* 
      NOTE: This function should be modified, when the callback is needed,
      the HAL_UART_MspDeInit can be implemented in the user file.
    */    
    if (huart->Instance == UART1) 
    {
        /* Disable Clock */
        __HAL_RCC_UART1_CLK_ENABLE();

        /* DeInitialization GPIO */
        /* A9:Tx  A10:Rx */
        HAL_GPIO_DeInit(GPIOA,GPIO_PIN_9 | GPIO_PIN_10);
		
		if (huart->Init.HwFlowCtl & UART_HWCONTROL_CTS) 
        {
            /* A11:CTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_11);
        }

        if (huart->Init.HwFlowCtl & UART_HWCONTROL_RTS) 
        {
            /* A12:RTS */
            HAL_GPIO_DeInit(GPIOA, GPIO_PIN_12);
        }
		
        /* NVIC DeInit */
        NVIC_DisableIRQ(UART1_IRQn);
		
    }
	else if(huart->Instance == UART2)
	{

	}
}


/******************************************************************************
*@brief : OPA MSP Initialization.such as module clock, IO share, ... 
*           OPA1 VinP:  PA1, PA3, PA7, DAC1
*           OPA1 VinM:  PA3, PC5
*           OPA1 Vout:  PA2
*               
*           OPA2 VinP:  PA7, PB0, OPA1, DAC2
*           OPA2 VinM:  PA5, PC5
*           OPA2 Vout:  PA6
*               
*           OPA3 VinP:  PB0, PA1, PB11, DAC1
*           OPA3 VinM:  PB0, PB10
*           OPA3 Vout:  PB1
*@param : hopa: OPA handle
*@return: None
******************************************************************************/
void HAL_OPA_MspInit(OPA_HandleTypeDef* hopa)
{  
    GPIO_InitTypeDef GPIO_Handle; 

    //Enable OPA clock
    __HAL_RCC_OPA_CLK_ENABLE();    
         
    if(hopa->Init.OPAx == OPA1)
    {
        //OPA1 VinP0:  PA1
        //OPA1 VinM0:  PA3
        //OPA1 Vout:  PA2
        
        __HAL_RCC_GPIOA_CLK_ENABLE(); 
        
        GPIO_Handle.Pin     = GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;    
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);

    }   
    else if(hopa->Init.OPAx == OPA2)
    {
        //OPA2 VinP0:  PA7
        //OPA2 VinM1:  PC5
        //OPA2 Vout:  PA6
        
        __HAL_RCC_GPIOA_CLK_ENABLE(); 
        
        GPIO_Handle.Pin     = GPIO_PIN_6 | GPIO_PIN_7;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;    
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        __HAL_RCC_GPIOC_CLK_ENABLE(); 
        
        GPIO_Handle.Pin     = GPIO_PIN_5;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;    
        HAL_GPIO_Init(GPIOC, &GPIO_Handle);        
        
    }
    else if(hopa->Init.OPAx == OPA3)
    {
        //OPA3 VinP0:  PB0
        //OPA3 VinM1:  PB10
        //OPA3 Vout:  PB1
        
        __HAL_RCC_GPIOB_CLK_ENABLE();
        
        GPIO_Handle.Pin     = GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_10;
        GPIO_Handle.Mode    = GPIO_MODE_ANALOG;
        GPIO_Handle.Pull    = GPIO_NOPULL;
        GPIO_Handle.Drive   = GPIO_DRIVE_LEVEL3;    
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
    }
}

/******************************************************************************
*@brief : OPA MSP De-initiation, such as IO share, module clock, ... 
*@param : hopa: pointer to OPA handle structure
*@return: None
******************************************************************************/
void HAL_OPA_MspDeInit(OPA_HandleTypeDef* hopa)
{
    if(hopa->Init.OPAx == OPA1)
    {
        //OPA1 VinP0:  PA1
        //OPA1 VinM0:  PA3
        //OPA1 Vout:  PA2
 
        HAL_GPIO_DeInit(GPIOA, GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3);

    }   
    else if(hopa->Init.OPAx == OPA2)
    {
        //OPA2 VinP0:  PA7
        //OPA2 VinM1:  PC5
        //OPA2 Vout:  PA6
        
        HAL_GPIO_DeInit(GPIOA, GPIO_PIN_6 | GPIO_PIN_7);
        HAL_GPIO_DeInit(GPIOC, GPIO_PIN_5);
              
        
    }
    else if(hopa->Init.OPAx == OPA3)
    {
        //OPA3 VinP0:  PB0
        //OPA3 VinM1:  PB10
        //OPA3 Vout:  PB1
        
        HAL_GPIO_DeInit(GPIOA, GPIO_PIN_0 | GPIO_PIN_1 | GPIO_PIN_10);
    }
}






