
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   
#include "main.h"

typedef enum
{
    TEST_OPA_PGA,
    TEST_OPA_SA,
    TEST_OPA_UG,
}TEST_OPA_TypeDef;


OPA_HandleTypeDef OPA2_Handle;
OPA_HandleTypeDef OPA3_Handle;

/******************************************************************************
*@brief : OPA Initiation as PGA mode. 
*@return: none
******************************************************************************/
void OPA_Init_PGA(void)
{ 
    OPA2_Handle.Instance = OPA;
    OPA2_Handle.Init.OPAx = OPA2;
    OPA2_Handle.Init.Mode = OPA_MODE_PGA;
    OPA2_Handle.Init.VinPSel = OPA_VINP_0;    
    OPA2_Handle.Init.VinM0En = OPA_VINM0_DISABLE;
    OPA2_Handle.Init.OutSel = OPA_OUT_GPIO;
    OPA2_Handle.Init.PolSel = OPA_POL_INVERT;
    OPA2_Handle.Init.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.Init.Gain = OPA_GAIN_2_1;
    OPA2_Handle.Init.TrimEn = OPA_TRIM_DISABLE;
    
    HAL_OPA_Init(&OPA2_Handle);
}

/******************************************************************************
*@brief : OPA Initiation as SA mode. 
*@return: none
******************************************************************************/
void OPA_Init_SA(void)
{
    OPA2_Handle.Instance = OPA;
    OPA2_Handle.Init.OPAx = OPA2;
    OPA2_Handle.Init.Mode = OPA_MODE_SA;
    OPA2_Handle.Init.VinPSel = OPA_VINP_0;    
    OPA2_Handle.Init.VinM0En = OPA_VINM0_DISABLE;
    OPA2_Handle.Init.OutSel = OPA_OUT_GPIO;
    OPA2_Handle.Init.PolSel = OPA_POL_NOINVERT;
    OPA2_Handle.Init.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.Init.Gain = OPA_GAIN_2_1;
    OPA2_Handle.Init.TrimEn = OPA_TRIM_DISABLE;
    
    HAL_OPA_Init(&OPA2_Handle);
}

/******************************************************************************
*@brief : OPA Initiation as UG mode. 
*@return: none
******************************************************************************/
void OPA_Init_UG(void)
{
    OPA2_Handle.Instance = OPA;
    OPA2_Handle.Init.OPAx = OPA2;
    OPA2_Handle.Init.Mode = OPA_MODE_UG;
    OPA2_Handle.Init.VinPSel = OPA_VINP_0;    
    OPA2_Handle.Init.VinM0En = OPA_VINM0_DISABLE;
    OPA2_Handle.Init.OutSel = OPA_OUT_GPIO;
    OPA2_Handle.Init.PolSel = OPA_POL_NOINVERT;
    OPA2_Handle.Init.Hsm = OPA_HSM_HIGH;
    OPA2_Handle.Init.Gain = OPA_GAIN_2_1;
    OPA2_Handle.Init.TrimEn = OPA_TRIM_DISABLE;
    
    HAL_OPA_Init(&OPA2_Handle);
}


/******************************************************************************
*@brief : OPA test. 
*@param : test_mode: test mode
*@return: none
******************************************************************************/
void OPA_Test(TEST_OPA_TypeDef testMode)
{
    printfS("OPA Test is start... \r\n");

    switch(testMode)
    {
        case TEST_OPA_PGA:
            printfS("OPA init as PGA mode. \r\n");
            OPA_Init_PGA();
            break;
        
        case TEST_OPA_SA:
            printfS("OPA init as SA mode. \r\n");
            OPA_Init_SA();
            break;
        
        case TEST_OPA_UG:
            printfS("OPA init as UG mode. \r\n");
            OPA_Init_UG();
            break;
    }
    
    printfS("OPA initiate OK!\r\n");
}


void APP_Test(void)
{
    OPA_Test(TEST_OPA_SA);

}