
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   


/******************************************************************************
* @brief : Low power powerdown test.
* @param : none
* @return: none
******************************************************************************/
void APP_LowPower_Powerdown_Test(void)
{
    RTC_ConfigTypeDef RTC_Handle;
    uint32_t wakeup_source;

    printfS("MCU Powerdown wakeup by IO Test \r\n"); 
    
    HAL_PMU_Init();
   
    
    HAL_Delay(5000);
    
    printfS("MCU enter Powerdown mode \r\n");  
    SysTick->CTRL = 0;   // disable systick        
    __set_PRIMASK(1);    // disable interrupt 
    SCB->ICSR = BIT25;   // clear systick pending bit 
    
    //HAL_PMU_StandbyWakeupIOConfig(STANDBY_WAKEUP1, STANDBY_WAKEUP_HIGH); 
    HAL_PMU_StandbyWakeupIOConfig(STANDBY_WAKEUP2, STANDBY_WAKEUP_HIGH); 
    
    HAL_PMU_EnterPowerdownMode();   
    
    SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk; /* Enable SysTick IRQ and SysTick Timer */               
    __set_PRIMASK(0);    // enable interrupt 
    while(1)
    {
        printfS("MCU never run here \r\n");
    }   
}

