
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   


/******************************************************************************
* @brief : Low power standby test.
* @param : mode: wakeup source select(IO or RTC) 
* @return: none
******************************************************************************/
void APP_LowPower_Standby_Mode_Test(uint8_t mode)
{
    RTC_ConfigTypeDef RTC_Handle;
    uint32_t wakeup_source;
    bool result = false;
    
    HAL_PMU_Init();
    
    result = HAL_PMU_ChecktStandbyStatus();
    
    if(result == true)
    {
        wakeup_source = HAL_PMU_GetStandbyWakeupSource();
        printfS("PMU->SR=0x%08x \n", wakeup_source);
    }
    switch(mode)
    {
        /* standbyģʽ IO */
        case PMU_STANDBY_IO_WAKEUP:
        {
            printfS("MCU Standby wakeup by IO Test \r\n");          
            HAL_PMU_StandbyWakeupRTCRelease(STANDBY_WAKEUP_32S);
            if(wakeup_source & PMU_SR_WUPFX_2)
            {
                printfS("WakeUp by PC13(WAKEUP2) \n");
                HAL_PMU_ClearStandbyWakeupStatus(PMU_SR_WUPFX_2);
            }
            
			PMU->STCLR |= 0xFFFF;
            
            HAL_Delay(5000);
            
            printfS("MCU enter standby mode \r\n");  
            SysTick->CTRL = 0;   // disable systick        
            __set_PRIMASK(1);    // disable interrupt 
            SCB->ICSR = BIT25;   // clear systick pending bit 
            HAL_PMU_StandbyWakeupIOConfig(STANDBY_WAKEUP2, STANDBY_WAKEUP_HIGH); 
            HAL_PMU_EnterStandbyMode();     
            SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk; /* Enable SysTick IRQ and SysTick Timer */               
            __set_PRIMASK(0);    // enable interrupt 
            while(1)
            {
                printfS("MCU never run here \r\n");
            }
        }
        /* standbyģʽ RTC */
        case PMU_STANDBY_RTC_WAKEUP:
        {	
            printfS("MCU Standby wakeup by RTC Test \r\n");
            HAL_PMU_StandbyWakeupIORelease(STANDBY_WAKEUP2);
            if(wakeup_source & PMU_SR_RTCWUF)
            {
                printfS("WakeUp by RTC \n");
                HAL_PMU_ClearStandbyWakeupStatus(PMU_SR_RTCWUF);
            }
	        PMU->STCLR |= 0xFFFF;//״̬
            
            HAL_Delay(5000);
            
            /********************************************/
            /**************** RTC Config ****************/
            /********************************************/
            RTC_Handle.ClockSource       = RTC_CLOCK_XTL;
            RTC_Handle.Compensation      = COMPENSATION_INCREASE;    // ʼʱӲ粻貹òֵΪ0
            RTC_Handle.CompensationValue = 0x05;                     // ʼʱӲ粻貹òֵΪ0

            HAL_RTC_Config(&RTC_Handle);

            printfS("MCU enter standby mode \r\n");
            SysTick->CTRL = 0;   // disable systick        
            __set_PRIMASK(1);    // disable interrupt 
            SCB->ICSR = BIT25;   // clear systick pending bit 
            HAL_PMU_StandbyWakeupRTCConfig(STANDBY_WAKEUP_32S); 
            HAL_PMU_EnterStandbyMode();                    
            SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk; /* Enable SysTick IRQ and SysTick Timer */               
            __set_PRIMASK(0);    // enable interrupt 
            while(1)
            {
                printfS("MCU never run here \r\n");
            }
        }
        default: break; 
    }
    
}

