#include "acm32g103_hal_conf.h"

/*****************************************************************
@	Stop͹ģʽرEflash,Ram
@	
@	
******************************************************************/
void Enter_Stop_Ram(uint8_t mode)
{
	volatile uint32_t i;
    
    SysTick->CTRL = 0;   // disable systick        
    __set_PRIMASK(1);    // disable interrupt 
    SCB->ICSR = BIT25;   // clear systick pending bit 
    
    __HAL_RCC_PMU_CLK_ENABLE();
    
    PMU->STCLR = 0xFFFFFFFF;//Clear all wake-up flags

    if(mode != PMU_CTL0_LPMS_STOP2)
    {        
        /*ʱлRCH*/
        RCC->RC64MCR |= RCC_RC64MCR_RC64MEN;
        while (!(RCC->RC64MCR & RCC_RC64MCR_RC64MRDY));
        RCC->CCR1 &= ~RCC_CCR1_SYSCLKSEL;	/* sysclk = RC64M  */
        RCC->RC64MCR &= ~RCC_RC64MCR_RC64MDIV; 
        
        /* رXTHXTL32K ʱ  */
        RCC->XTHCR &= (~RCC_XTHCR_XTHEN);     // XTH  Disable
        RCC->PLLCR &= (~RCC_PLLCR_PLLEN);      //PLL Disable
        RCC->STDBYCTRL &= (~RCC_STDBYCTRL_RC32EN); //RC32K Disable
        RCC->STDBYCTRL &= (~RCC_STDBYCTRL_XTLEN); //XTL Disable
        
       /* All Clock Disable */
        RCC->CLKOCR &= (~RCC_CLKOCR_BUZZER2EN);    // Buzzer2 Disable
        RCC->CLKOCR &= (~RCC_CLKOCR_BUZZER1EN);    // Buzzer1 Disable

        RCC->APB1ENR = RCC_APB1ENR_PMUCKEN;//PMU
        RCC->APB2ENR = RCC_APB2ENR_EXTICKEN ;//EXTI 
        
        PMU->CTRL1 &= (~PMU_CTL1_LVDEN);//ֹLVD 

        PMU->CTRL0 |= PMU_CTL0_RC64M_DIV_EN;//RC64Mѡ16Ƶ
        
        /* STOP ģʽ¹رRC64M */
        PMU->CTRL0 |= PMU_CTL0_RC64MPDEN;//ֹͣSTOPģʽ£RC64M Զر 
    }
    
    EXTI->PDR = EXTI_ALL_LINE_MASK;//Clear all EXTI interrupt pending 
    
    /* ע⣺STOPģʽǰҪMLDO12ѹԶ(MLDO12LV)LPLDO12ѹ(LPLDO12LV)ԼСرMLDO12ĵѹ */
    PMU->CTRL0 = ((PMU->CTRL0 & (~PMU_CTL0_MLDO12_LV_Msk)) | (0x01 << PMU_CTL0_MLDO12_LV_Pos));//MLDO12ѹΪ1.0V
    PMU->CTRL0 = ((PMU->CTRL0 & (~PMU_CTL0_LPLDO12_LV_Msk)) | (0x06 << PMU_CTL0_LPLDO12_LV_Pos));//LPLDO12ѹΪ1.17V
    
    if(mode == PMU_CTL0_LPMS_STOP0)
    {          
        PMU->CTRL0 |= PMU_CTL0_MLDO12_LOWP;//MLDOǷ͹ģʽ       
    }
    else if(mode == PMU_CTL0_LPMS_STOP2)
    {
        /*ʱлRC32K*/
        RCC->STDBYCTRL |= RCC_STDBYCTRL_RC32EN;//RC32Kʱʹ 
        while(0 == ((RCC->STDBYCTRL) & RCC_STDBYCTRL_RC32KRDY));
        RCC->CCR1 = RCC_CCR1_SYSCLKSEL_0;       
    }  
    
    MODIFY_REG(PMU->CTRL0, PMU_CTL0_LPMS_Msk, mode);//MLDO12Ϊ1.2V 
        
    if(mode != PMU_CTL0_LPMS_STOP2)
    {
        /*Eflash sleepģʽ */
        EFC->CTRL |= EFC_CTRL_SLEEP;
    }
    
    SET_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));   // Set SLEEPDEEP bit of Cortex System Control Register 
      

	/*---------------stopģʽ-----------*/
	/* Wait For Interrupt */   
    __WFI();
	
	/*---------------Ѻ-------------*/
	CLEAR_BIT(SCB->SCR, ((uint32_t)SCB_SCR_SLEEPDEEP_Msk));

    PMU->CTRL0 &= (~PMU_CTL0_MLDO12_LV_Msk);    
	
    if(mode != PMU_CTL0_LPMS_STOP2)
    {    
        /* ѺEflash˳Sleepģʽ */
        EFC->CTRL &= (~EFC_CTRL_SLEEP);
        for(i = 0; i < 10 *5000; i++); //Elash˳Sleepʱ10uS
    }
    //Systick
    SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk; /* Enable SysTick IRQ and SysTick Timer */ 
    //ж               
    __set_PRIMASK(0);    // enable interrupt 
}


