
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 



/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    GPIO_InitTypeDef    GPIO_InitStruct;
    RCC_MCOInitTypeDef  MCO_InitStruct = {0};
    RCC_OscInitTypeDef  RCC_OscInitStruct = {0};
    RCC_ClkInitTypeDef  RCC_ClkInitStruct = {0};
    
    MCO_OutputTypedef mco[] = 
    {
        {   RCC_MCO_NONE,       "MCO1 Output : None\r\n"     },
        {   RCC_MCO_HCLK,       "MCO1 Output HCLK : 40MHz\r\n"    },
        {   RCC_MCO_RC64M,      "MCO1 Output RC64M : 4MHz\r\n"     },
        {   RCC_MCO_RC32K,      "MCO1 Output RC32K: 32KHz\r\n"    },
        {   RCC_MCO_XTH,        "MCO1 Output XTH : 12MHz\r\n"    },
        {   RCC_MCO_XTL,        "MCO1 Output XTL : 32768Hz\r\n"  },
        {   RCC_MCO_PLLCLK,     "MCO1 Output PLL : 120MHz\r\n"   },
        {   RCC_MCO_PCLK1,      "MCO1 Output PCLK1 : 20MHz\r\n"    },
        {   RCC_MCO_PCLK2,      "MCO1 Output PCLK2 : 20MHz\r\n"    },
        {   RCC_MCO_SYSCLK,     "MCO1 Output SYSCLK: 120MHz\r\n"   },
        {   RCC_MCO_FCLKDIV8,    "MCO1 Output FCLKDIV8 : 5MHz\r\n"     },
    };
    
    
	BSP_LED_Init();
	BSP_LED_On();
    HAL_Delay(500);
	
    /* MCO1 */
    __HAL_RCC_GPIOA_CLK_ENABLE();

    GPIO_InitStruct.Pin       = GPIO_PIN_8;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL7;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;

    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
	
    /* MCO2 */
    __HAL_RCC_GPIOB_CLK_ENABLE();

    GPIO_InitStruct.Pin       = GPIO_PIN_1;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL7;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_3;

    HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);
    
    /* ĬϵͳʱΪPLLPLLǰ轫ϵͳʱлRC64M */
    if (HAL_RCC_SwitchSYSCLK(RCC_SYSCLKSOURCE_RC64M) != HAL_OK)
    {
        while (1);
    }
    
    /* RC64MRC32KXTHXTLPLL */
    RCC_OscInitStruct.OscType = RCC_OSCTYPE_RC64M | RCC_OSCTYPE_RC32K | RCC_OSCTYPE_XTH | \
                                RCC_OSCTYPE_XTL | RCC_OSCTYPE_PLL;
    
    RCC_OscInitStruct.RC64M = ENABLE;    
    RCC_OscInitStruct.RC64MDiv16 = ENABLE;    
    
    RCC_OscInitStruct.RC32K = ENABLE;
    
    RCC_OscInitStruct.XTH = ENABLE;
    RCC_OscInitStruct.XTHBypass = DISABLE;  
    
    RCC_OscInitStruct.XTL = ENABLE;
    RCC_OscInitStruct.XTLBypass = DISABLE; 
    RCC_OscInitStruct.XTLDrive = RCC_XTL_DRIVE0;  
    
    RCC_OscInitStruct.PLL.PLL = ENABLE;
    RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_RC64M_DIV16;
    RCC_OscInitStruct.PLL.PLLM = 0U;
    RCC_OscInitStruct.PLL.PLLN = 0U;
    RCC_OscInitStruct.PLL.PLLF = 15U;
    
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
    {
        while (1);
    }
    
    /* ϵͳʱлPLL   */
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.SYSCLKDiv0 = RCC_SYSDIV0_DIV_3;
    RCC_ClkInitStruct.SYSCLKDiv1 = RCC_SYSDIV1_DIV_1;
    RCC_ClkInitStruct.PCLK1Div = RCC_PCLK1_DIV_2;
    RCC_ClkInitStruct.PCLK2Div = RCC_PCLK2_DIV_2;
    
    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct) != HAL_OK)
    {
        while (1);
    }
    
    /* MCO1MCO2лͬʱ */
    for (i=0; i<(sizeof(mco) / sizeof(MCO_OutputTypedef)); i++)
    {
        MCO_InitStruct.Output = mco[i].Output;
        MCO_InitStruct.MCO1 = ENABLE;
        MCO_InitStruct.MCO1Div = 0U;
        MCO_InitStruct.MCO1RevPol = DISABLE;
        MCO_InitStruct.MCO2 = ENABLE;
        MCO_InitStruct.MCO2Div = 9U;
        MCO_InitStruct.MCO2RevPol = DISABLE;
        
        HAL_RCC_MCOConfig(&MCO_InitStruct);
        
		HAL_Delay(100);
        BSP_UART_Init();
		printfS("%s", mco[i].str);
		printfS("MCO2 : MCO1 divided 10\r\n");
        
        BSP_LED_Toggle();
		HAL_Delay(100);
    }
    
    BSP_LED_Off();
    while(1)
    {
		HAL_Delay(500);
    };
}



