
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "main.h"
#include "acm32g103_it.h"


void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	HAL_IncTick();  
}


void EXTI0_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_0);
}

void EXTI1_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_1);
}

void EXTI2_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_2);
}

void EXTI3_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_3);
}

void EXTI4_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_4);
}

void EXTI9_5_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_5);
	HAL_EXTI_IRQHandler(GPIO_PIN_6);
	HAL_EXTI_IRQHandler(GPIO_PIN_7);
	HAL_EXTI_IRQHandler(GPIO_PIN_8);
	HAL_EXTI_IRQHandler(GPIO_PIN_9);
}


void EXTI15_10_IRQHandler(void)
{
	HAL_EXTI_IRQHandler(GPIO_PIN_10);
	HAL_EXTI_IRQHandler(GPIO_PIN_11);
	HAL_EXTI_IRQHandler(GPIO_PIN_12);
	HAL_EXTI_IRQHandler(GPIO_PIN_13);
	HAL_EXTI_IRQHandler(GPIO_PIN_14);
	HAL_EXTI_IRQHandler(GPIO_PIN_15);
}

extern bool galarmFlag;
extern bool gtemperFlag1;
extern bool gtemperFlag2;
void RTC_IRQHandler(void)
{
    uint32_t status;
    /* RTC domain write enable */
	SET_BIT(PMU->CTRL0,PMU_CTL0_RTC_WE);
    
    status = RTC->SR;
    printfS("RTC->SR = 0x%0x\r\n", RTC->SR);
    if (status & RTC_SR_ALM) 
    {
        RTC->SR = RTC_SR_ALM;

        galarmFlag = true;
    }
    
    if ((status & RTC_SR_STP1FIE)&&(RTC->IE & RTC_IE_STP1FIE))//TAMP1½ 
    {
        RTC->SR = RTC_SR_STP1FIE;
        
        gtemperFlag1 = true;
    }
    if ((status & RTC_SR_STP1RIE)&&(RTC->IE & RTC_IE_STP1RIE))//TAMP1 
    {
        RTC->SR = RTC_SR_STP1RIE;
        
        gtemperFlag1 = true;
    }
    
    if ((status & RTC_SR_STP2FIE)&&(RTC->IE & RTC_IE_STP2FIE))//TAMP2½  
    {
        RTC->SR = RTC_SR_STP2FIE;
        
        gtemperFlag2 = true;
    }
    if ((status & RTC_SR_STP2RIE)&&(RTC->IE & RTC_IE_STP2RIE))//TAMP2 
    {
        RTC->SR = RTC_SR_STP2RIE;
        
        gtemperFlag2 = true;
    }
	
	if(status & RTC_SR_WUTF)
	{
		RTC->SR = RTC_SR_WUTF;
		printfS("WUTF Occur.....\r\n");
	}
	if (status & RTC_SR_MIN) 
    {
        RTC->SR = RTC_SR_MIN;
		printfS("MIN Interrupt Occur.....\r\n");
    }
    RTC->SR = 0xFFFFFFFF;
}
