/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/
#include "hal.h"

void HAL_SPI_MspInit(SPI_HandleTypeDef *hspi)
{
    /* 
      NOTE : This function should be modified by the user.
    */
    
    /* For Example */
    GPIO_InitTypeDef GPIO_Handle = {0}; 
    
    /* SPI1 */
    if (hspi->Instance == SPI1)
    {
        /* Enable Clock */
        __HAL_RCC_SPI1_CLK_ENABLE();
        __HAL_RCC_GPIOA_CLK_ENABLE();
        
        /*  PA4    CS        AF0 
            PA5    SCK       AF0       
            PA12   MOSI      AF0
            PA11   MISO      AF0
            PA7    IO2(WP)   AF3
            PA6    IO3(HOLD) AF3
        */
        
        GPIO_Handle.Pin = GPIO_PIN_4 | GPIO_PIN_5;
        GPIO_Handle.Mode = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull = GPIO_PULLUP;
        GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate = GPIO_FUNCTION_0;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin = GPIO_PIN_11 | GPIO_PIN_12 ;
        GPIO_Handle.Mode = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull = GPIO_PULLUP;
        GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate = GPIO_FUNCTION_0;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        printfS("SPI1 PINs selected:\r\n");
        printfS("SPI1 CS  :PA4\r\n");
        printfS("SPI1 SCK :PA5\r\n");
        printfS("SPI1 MOSI:PA12\r\n");
        printfS("SPI1 MISO:PA11\r\n");
        
        if (hspi->Init.X_Mode == SPI_4X_MODE) 
        {
            GPIO_Handle.Pin = GPIO_PIN_6 | GPIO_PIN_7;
            GPIO_Handle.Mode = GPIO_MODE_AF_PP;
            GPIO_Handle.Pull = GPIO_PULLUP;
            GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
            GPIO_Handle.Alternate = GPIO_FUNCTION_3;
            HAL_GPIO_Init(GPIOA, &GPIO_Handle);
            printfS("SPI1 WP  :PA7\r\n");
            printfS("SPI1 HOLD:PA6\r\n");
        }
        
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(SPI1_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(SPI1_IRQn);
    }
    /* SPI2 */
    else if (hspi->Instance == SPI2) 
    {
       /* Enable Clock */
        __HAL_RCC_SPI2_CLK_ENABLE();
        __HAL_RCC_GPIOB_CLK_ENABLE();
        __HAL_RCC_GPIOC_CLK_ENABLE();
        
        /*  PB9    CS        AF3 
            PB8    SCK       AF3       
            PB7    MOSI      AF3
            PB6    MISO      AF3
            PC7    IO2(WP)   AF1
            PC6    IO3(HOLD) AF1
        */
        
        GPIO_Handle.Pin = GPIO_PIN_6 | GPIO_PIN_7 | GPIO_PIN_8 | GPIO_PIN_9 ;
        GPIO_Handle.Mode = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull = GPIO_PULLUP;
        GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate = GPIO_FUNCTION_3;
        HAL_GPIO_Init(GPIOB, &GPIO_Handle);
        
        printfS("SPI2 PINs selected:\r\n");
        printfS("SPI2 CS  :PB9\r\n");
        printfS("SPI2 SCK :PB8\r\n");
        printfS("SPI2 MOSI:PB7\r\n");
        printfS("SPI2 MISO:PB6\r\n");
        
        if (hspi->Init.X_Mode == SPI_4X_MODE) 
        {
            GPIO_Handle.Pin = GPIO_PIN_6 | GPIO_PIN_7;
            GPIO_Handle.Mode = GPIO_MODE_AF_PP;
            GPIO_Handle.Pull = GPIO_PULLUP;
            GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
            GPIO_Handle.Alternate = GPIO_FUNCTION_1;
            HAL_GPIO_Init(GPIOC, &GPIO_Handle);
            printfS("SPI2 WP  :PC7\r\n");
            printfS("SPI2 HOLD:PC6\r\n");
        }
        
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(SPI2_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(SPI2_IRQn);
    }
    /* SPI3 */
    else if (hspi->Instance == SPI3)
    {
        /* Enable Clock */
        __HAL_RCC_SPI3_CLK_ENABLE();
        __HAL_RCC_GPIOA_CLK_ENABLE();
        __HAL_RCC_GPIOC_CLK_ENABLE();
        
        /*  PA15   CS        AF4 
            PC10   SCK       AF2       
            PC12   MOSI      AF2
            PC11   MISO      AF2
            PC9    IO2(WP)   AF2
            PC8    IO3(HOLD) AF2
        */
        
        GPIO_Handle.Pin = GPIO_PIN_15 ;
        GPIO_Handle.Mode = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull = GPIO_PULLUP;
        GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate = GPIO_FUNCTION_4;
        HAL_GPIO_Init(GPIOA, &GPIO_Handle);
        
        GPIO_Handle.Pin = GPIO_PIN_10 | GPIO_PIN_11 | GPIO_PIN_12 ;
        GPIO_Handle.Mode = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull = GPIO_PULLUP;
        GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
        GPIO_Handle.Alternate = GPIO_FUNCTION_2;
        HAL_GPIO_Init(GPIOC, &GPIO_Handle);
        
        printfS("SPI3 PINs selected:\r\n");
        printfS("SPI3 CS  :PA15\r\n");
        printfS("SPI3 SCK :PC10\r\n");
        printfS("SPI3 MOSI:PC12\r\n");
        printfS("SPI3 MISO:PC11\r\n");
        
        if (hspi->Init.X_Mode == SPI_4X_MODE) 
        {
            GPIO_Handle.Pin = GPIO_PIN_8 | GPIO_PIN_9;
            GPIO_Handle.Mode = GPIO_MODE_AF_PP;
            GPIO_Handle.Pull = GPIO_PULLUP;
            GPIO_Handle.Drive = GPIO_DRIVE_LEVEL3;
            GPIO_Handle.Alternate = GPIO_FUNCTION_2;
            HAL_GPIO_Init(GPIOC, &GPIO_Handle);
            printfS("SPI3 WP  :PC9\r\n");
            printfS("SPI3 HOLD:PC8\r\n");
        }
        
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(SPI3_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(SPI3_IRQn);
    }
    
    printfS("Modify HAL_SPI_MspInit() if you select other SPI PINs\r\n\r\n");
}
