
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "main.h"


void HAL_MSP_Delay_Count(uint32_t count)
{
    volatile uint32_t  cnt; 
    
    cnt = count; 
    
    while(cnt--);      
    
}

/*********************************************************************************
* Function    : HAL_TIMER_MSP_Init
* Description : MSP init, mainly about clock, nvic   
* Input       : timer handler 
* Output      : 0: success; else:error    
* Author      : xwl                       
**********************************************************************************/
uint32_t HAL_TIMER_MSP_Init(TIM_HandleTypeDef * htim)  
{ 
    if (TIM1 == htim->Instance)
    {
        __HAL_RCC_TIM1_RESET();          
        __HAL_RCC_TIM1_CLK_ENABLE(); 
    }
    else if(TIM3 == htim->Instance)
    {
        __HAL_RCC_TIM3_RESET();          
        __HAL_RCC_TIM3_CLK_ENABLE();  
    }
            
    return HAL_OK;    
}  


uint32_t HAL_TIMER_Base_MspDeInit(TIM_HandleTypeDef * htim)  
{
    GPIO_InitTypeDef gpio_init; 
    
    __HAL_RCC_GPIOC_CLK_ENABLE();  
    __HAL_RCC_GPIOA_CLK_ENABLE();    
	HAL_MSP_Delay_Count(5);   
    
	gpio_init.Pin = GPIO_PIN_8; 
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;  
	gpio_init.Mode = GPIO_MODE_INPUT;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_1;          
	HAL_GPIO_Init(GPIOC, &gpio_init);    
    
    gpio_init.Pin = GPIO_PIN_7;   
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;  
	gpio_init.Mode = GPIO_MODE_INPUT;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_1;          
	HAL_GPIO_Init(GPIOA, &gpio_init);    
    
    return HAL_OK;    
}  

/*********************************************************************************
* Function    : TIM1_MSP_Post_Init      
* Description : timer 1 gpio initiation, configure PC8 as TIMER1 CH1 
* Input       : none     
* Output      : none 
* Author      : xwl                       
**********************************************************************************/ 
void TIM1_MSP_Post_Init(void)     
{
	GPIO_InitTypeDef gpio_init; 

    __HAL_RCC_GPIOC_CLK_ENABLE();  
	HAL_MSP_Delay_Count(5);   
    
	gpio_init.Pin = GPIO_PIN_8;  //TIM1_CH1  
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;    
	gpio_init.Mode = GPIO_MODE_AF_PP;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_1;          
	HAL_GPIO_Init(GPIOC, &gpio_init);    // PC8   	  
}  


/*********************************************************************************
* Function    : TIM3_MSP_Post_Init      
* Description : timer 3 gpio initiation, configure PA7 as TIMER3 CH2  
* Input       : none     
* Output      : none 
* Author      : xwl                       
**********************************************************************************/ 
void TIM3_MSP_Post_Init(void)       
{
	GPIO_InitTypeDef gpio_init;  
    
    __HAL_RCC_GPIOA_CLK_ENABLE();  
	HAL_MSP_Delay_Count(5);   
	
	gpio_init.Pin = GPIO_PIN_7;  //TIM3_CH2  
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;    
	gpio_init.Mode = GPIO_MODE_AF_PP;     
	gpio_init.Pull = GPIO_PULLUP;    
	gpio_init.Alternate = GPIO_FUNCTION_1;       
	HAL_GPIO_Init(GPIOA, &gpio_init);  	// PA7    
}  


