
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "main.h"


void HAL_MSP_Delay_Count(uint32_t count)
{
    volatile uint32_t  cnt; 
    
    cnt = count; 
    
    while(cnt--);      
    
}

/*********************************************************************************
* Function    : HAL_TIMER_MSP_Init
* Description : MSP init, mainly about clock, nvic   
* Input       : timer handler 
* Output      : 0: success; else:error    
* Author      : xwl                       
**********************************************************************************/
uint32_t HAL_TIMER_MSP_Init(TIM_HandleTypeDef * htim)  
{   
    if (0 == IS_TIMER_INSTANCE(htim->Instance))
    {
        return HAL_ERROR; //instance error 
    }
    
    __HAL_RCC_TIM6_RESET();   
    __HAL_RCC_TIM6_CLK_ENABLE();          
    NVIC_ClearPendingIRQ(TIM6_IRQn);   
    NVIC_EnableIRQ(TIM6_IRQn);   
    
    return HAL_OK;  
}  

uint32_t HAL_TIMER_Base_MspDeInit(TIM_HandleTypeDef * htim)  
{
    if (0 == IS_TIMER_INSTANCE(htim->Instance))
    {
        return HAL_ERROR; //instance error 
    }
    
    __HAL_RCC_TIM6_CLK_DISABLE();   
    NVIC_DisableIRQ(TIM6_IRQn);  
    
    return HAL_OK;    
}  



