
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h"   
#include "app.h"   


/*********************************************************************************
* Function    : main
* Description : 
* Input       : 
* Outpu       : 
* Author      : xwl                        Date : 2022-06  
**********************************************************************************/
int main(void)
{	
	HAL_Init();
    SystemClock_Config();
	
    BSP_UART_Init();  
	
    printfS("\r\n\r\n****************************************************************************************************\r\n");
	printfS("system startup\r\n\r\n");
    
	printfS("HCLK: %uHz\r\n", HAL_RCC_GetHCLKFreq());
	printfS("PCLK1: %uHz\r\n", HAL_RCC_GetPCLK1Freq());
	printfS("PCLK2: %uHz\r\n", HAL_RCC_GetPCLK2Freq());
    printfS("\r\n");
    
    Timer_Update_Test();  
	
    while(1)
    {
        
    }
}



