
/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/

#include "main.h"


void HAL_MSP_Delay_Count(uint32_t count)
{
    volatile uint32_t  cnt; 
    
    cnt = count; 
    
    while(cnt--);      
    
}

/*********************************************************************************
* Function    : HAL_TIMER_MSP_Init
* Description : MSP init, mainly about clock, nvic   
* Input       : timer handler 
* Output      : 0: success; else:error    
* Author      : xwl                       
**********************************************************************************/
uint32_t HAL_TIMER_MSP_Init(TIM_HandleTypeDef * htim)  
{ 
    __HAL_RCC_TIM1_CLK_DISABLE();     
    if (0 == IS_TIMER_INSTANCE(htim->Instance))
    {
        return HAL_ERROR; //instance error 
    }    
    __HAL_RCC_TIM1_RESET();      
    
    __HAL_RCC_TIM1_CLK_ENABLE(); 
   
    NVIC_ClearPendingIRQ(TIM1_CC_IRQn);   
    NVIC_EnableIRQ(TIM1_CC_IRQn);     
       
    return HAL_OK;    
}  


uint32_t HAL_TIMER_Base_MspDeInit(TIM_HandleTypeDef * htim)  
{
    GPIO_InitTypeDef gpio_init; 
    
    __HAL_RCC_GPIOC_CLK_ENABLE();  
	HAL_MSP_Delay_Count(5);   
    
	gpio_init.Pin = GPIO_PIN_8;  //TIM1_CH1  
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;  
	gpio_init.Mode = GPIO_MODE_INPUT;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_1;          
	HAL_GPIO_Init(GPIOC, &gpio_init);    // PC8  
    
    __HAL_RCC_TIM1_CLK_DISABLE();
    
    return HAL_OK;    
}  


/*********************************************************************************
* Function    : TIM1_MSP_Pre_Init      
* Description : timer 1 initiation, includes clock, nvic 
* Input       : htim, timer handler     
* Output      : none 
* Author      : xwl                       
**********************************************************************************/ 
void TIM1_MSP_Pre_Init(TIM_HandleTypeDef * htim)   
{
	HAL_TIMER_MSP_Init(htim);      
} 

/*********************************************************************************
* Function    : TIM1_MSP_Post_Init      
* Description : timer 1 gpio initiation, configure PC8 as TIMER1 CH1 
* Input       : none     
* Output      : none 
* Author      : xwl                       
**********************************************************************************/ 
void TIM1_MSP_Post_Init(void)     
{
	GPIO_InitTypeDef gpio_init; 

    __HAL_RCC_GPIOC_CLK_ENABLE();  
	HAL_MSP_Delay_Count(5);   
    
	gpio_init.Pin = GPIO_PIN_8;  //TIM1_CH1  
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;   
	gpio_init.Mode = GPIO_MODE_AF_PP;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_1;          
	HAL_GPIO_Init(GPIOC, &gpio_init);    // PC8   	  
}  


