/******************************************************************************
*@file  : acm32g103_hal_msp.c
*@brief : HAL MSP module . not need header file 
******************************************************************************/
#include "hal.h"

void HAL_UART_7816M_MspInit(UART_HandleTypeDef* huart)
{
    GPIO_InitTypeDef    GPIO_InitStruct ={0}; 

    UART_TypeDef *instance = huart->Instance;

    if(instance == UART1)
    {
        __HAL_RCC_GPIOA_CLK_ENABLE();
        __HAL_RCC_UART1_CLK_ENABLE();
        
        /*7816 IO: PA9*/
        GPIO_InitStruct.Pin       = GPIO_PIN_9;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_OD;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_1;       
        HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

        /*7816 RST: PA10*/
        GPIO_InitStruct.Pin       = GPIO_PIN_10;
        GPIO_InitStruct.Mode      = GPIO_MODE_OUTPUT_PP;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;       
        HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

        /*7816 CLK: PA8*/
        GPIO_InitStruct.Pin       = GPIO_PIN_8;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_6;       
        HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
        
        printfS("7816 PINs:\r\n");
        printfS("7816 RST: PA10\r\n");
        printfS("7816 CLK: PA8\r\n");
        printfS("7816 IO : PA9\r\n\r\n");

        NVIC_ClearPendingIRQ(UART1_IRQn);
        NVIC_EnableIRQ(UART1_IRQn);    
    }
    else if(instance == UART2)
    {
        __HAL_RCC_GPIOB_CLK_ENABLE();
        __HAL_RCC_UART2_CLK_ENABLE();


        /*7816 IO: PB3*/
        GPIO_InitStruct.Pin       = GPIO_PIN_3;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_OD;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_5;       
        HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);


        /*7816 RST: PB4*/
        GPIO_InitStruct.Pin       = GPIO_PIN_4;
        GPIO_InitStruct.Mode      = GPIO_MODE_OUTPUT_PP;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;       
        HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

        /*7816 CLK: PB5*/
        GPIO_InitStruct.Pin       = GPIO_PIN_5;
        GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
        GPIO_InitStruct.Pull      = GPIO_PULLUP;
        GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
        GPIO_InitStruct.Alternate = GPIO_FUNCTION_5;       
        HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

        NVIC_ClearPendingIRQ(UART2_IRQn);
        NVIC_EnableIRQ(UART2_IRQn);    
    }
    else if(instance == UART3)
    {
        /* not implemented */
        assert_param(0);
    }
    else if(instance == UART4)
    {
        /* not implemented */
        assert_param(0);
    }
}


