;********************************************************************************
;* File Name          : Startup_ACM32F4.s
;* Description        : This module performs:
;*                      - Set the initial SP
;*                      - Set the initial PC == _iar_program_start,
;*                      - Set the vector table entries with the exceptions ISR
;*                        address.
;*                      - Branches to main in the C library (which eventually
;*                        calls main()).
;*                      After Reset the Cortex-M33 processor is in Thread mode,
;*                      priority is Privileged, and the Stack is set to Main.
;********************************************************************************
;*
;* <h2><center>&copy; Copyright (c) 2021 Aisinochip.
;* All rights reserved.</center></h2>
;*
;*******************************************************************************


        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        EXTERN  SystemInit
        PUBLIC  __vector_table
        PUBLIC  __Vectors
        PUBLIC  __Vectors_End
        PUBLIC  __Vectors_Size

        DATA
__vector_table
        DCD     sfe(CSTACK)
        DCD     Reset_Handler              ; Reset Handler
        DCD     NMI_Handler                ; NMI Handler
        DCD     HardFault_Handler          ; Hard Fault Handler
        DCD     MemManage_Handler          ; MPU Fault Handler
        DCD     BusFault_Handler           ; Bus Fault Handler
        DCD     UsageFault_Handler         ; Usage Fault Handler
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     0                          ; Reserved
        DCD     SVC_Handler                ; SVCall Handler
        DCD     DebugMon_Handler           ; Debug Monitor Handler
        DCD     0                          ; Reserved
        DCD     PendSV_Handler             ; PendSV Handler
        DCD     SysTick_Handler            ; SysTick Handler

         ; External Interrupts
                DCD     WDT_IRQHandler              ; 0:  WDT_IRQHandler 
                DCD     LVD_IRQHandler              ; 1:  LVD_IRQHandler                     
                DCD     RTC_IRQHandler              ; 2:  RTC_IRQHandler
                DCD     RSV1_IRQHandler             ; 3:                    
                DCD     EFC_IRQHandler              ; 4:  EFC_IRQHandler 
                DCD     SRAM_PARITY_IRQHandler      ; 5:  SRAM_PARITY_IRQHandler
                DCD     CLKRDY_IRQHandler           ; 6:  CLKRDY_IRQHandler    
                DCD     EXTI0_IRQHandler            ; 7:  EXTI0_IRQHandler     
                DCD     EXTI1_IRQHandler            ; 8:  EXTI1_IRQHandler     
                DCD     EXTI2_IRQHandler            ; 9:  EXTI2_IRQHandler
                DCD     EXTI3_IRQHandler            ; 10: EXTI3_IRQHandler    
                DCD     EXTI4_IRQHandler            ; 11: EXTI4_IRQHandler    
                DCD     DMA1_IRQHandler             ; 12: DMA1_IRQHandler    
                DCD     DMA2_IRQHandler             ; 13: DMA2_IRQHandler    
                DCD     ADC1_2_IRQHandler           ; 14: ADC1_2_IRQHandler    
                DCD     RSV2_IRQHandler             ; 15:        
                DCD     DAC_IRQHandler              ; 16: DAC_IRQHandler    
                DCD     COMP1_2_IRQHandler          ; 17: COMP1_2_IRQHandler
                DCD     USB_IRQHandler              ; 18: USB_IRQHandler    
                DCD     CAN1_IRQHandler             ; 19: CAN1_IRQHandler
                DCD     CAN2_IRQHandler             ; 20: CAN2_IRQHandler    
                DCD     EXTI9_5_IRQHandler          ; 21: EXTI9_5_IRQHandler    
                DCD     TIM1_BRK_UP_TRG_COM_IRQHandler    ; 22: TIM1_BRK_UP_TRG_COM_IRQHandler
                DCD     TIM1_CC_IRQHandler          ; 23: TIM1_CC_IRQHandler
                DCD     TIM2_IRQHandler             ; 24: TIM2_IRQHandler
                DCD     TIM3_IRQHandler             ; 25: TIM3_IRQHandler 
                DCD     TIM6_IRQHandler             ; 26: TIM6_IRQHandler
                DCD     TIM7_IRQHandler             ; 27: TIM7_IRQHandler
                DCD     TIM8_BRK_UP_TRG_COM_IRQHandler    ; 28: TIM8_BRK_UP_TRG_COM_IRQHandler
                DCD     TIM8_CC_IRQHandler          ; 29: TIM8_CC_IRQHandler
                DCD     TIM15_IRQHandler            ; 30: TIM15_IRQHandler    
                DCD     TIM16_IRQHandler            ; 31: TIM16_IRQHandler
                DCD     TIM17_IRQHandler            ; 32: TIM17_IRQHandler        
                DCD     I2C1_IRQHandler             ; 33: I2C1_IRQHandler     
                DCD     I2C2_IRQHandler             ; 34: I2C2_IRQHandler    
                DCD     SPI1_IRQHandler             ; 35: SPI1_IRQHandler     
                DCD     SPI2_IRQHandler             ; 36: SPI2_IRQHandler    
                DCD     SPI3_IRQHandler             ; 37: SPI3_IRQHandler    
                DCD     I2S1_IRQHandler             ; 38: I2S1_IRQHandler    
                DCD     I2S2_IRQHandler             ; 39: I2S2_IRQHandler
                DCD     UART1_IRQHandler            ; 40: UART1_IRQHandler     
                DCD     UART2_IRQHandler            ; 41: UART2_IRQHandler
                DCD     UART3_IRQHandler            ; 42: UART3_IRQHandler
                DCD     UART4_IRQHandler            ; 43: UART4_IRQHandler
                DCD     EXTI15_10_IRQHandler        ; 44: EXTI15_10_IRQhandler
                DCD     USB_WAKEUP_IRQHandler       ; 45: USB_WAKEUP_IRQHandler
                DCD     LPUART1_IRQHandler          ; 46: LPUART1_IRQHandler
                DCD     LPTIM1_IRQHandler           ; 47: LPTIM1_IRQHandler
                DCD     RSV3_IRQHandler             ; 48:
                DCD     AES_IRQHandler              ; 49: AES_IRQHandler
                DCD     FPU_IRQHandler              ; 50: FPU_IRQHandler
                DCD     RSV4_IRQHandler             ; 51:
                DCD     RSV5_IRQHandler       ; 52: STOP_RESET_IRQHandler        
                DCD     TIM4_IRQHandler             ; 53: TIM4_IRQHandler 
                DCD     COMP3_4_IRQHandler          ; 54: COMP3_4_IRQHandler
                DCD     IWDT_WAKEUP_IRQHandler      ; 55: IWDT_WAKEUP_IRQHandler
__Vectors_End

__Vectors       EQU   __vector_table
__Vectors_Size  EQU   __Vectors_End - __Vectors

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB
        PUBWEAK Reset_Handler
        SECTION .text:CODE:NOROOT:REORDER(2)
Reset_Handler
        LDR     R0, =SystemInit
        BLX     R0
        LDR     R0, =__iar_program_start
        BX      R0

        PUBWEAK NMI_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK MemManage_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
MemManage_Handler
        B MemManage_Handler

        PUBWEAK BusFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
BusFault_Handler
        B BusFault_Handler

        PUBWEAK UsageFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
UsageFault_Handler
        B UsageFault_Handler

        PUBWEAK SVC_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
SVC_Handler
        B SVC_Handler

        PUBWEAK DebugMon_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
DebugMon_Handler
        B DebugMon_Handler

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
PendSV_Handler
        B PendSV_Handler

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
SysTick_Handler
        B SysTick_Handler

        PUBWEAK WDT_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WDT_IRQHandler
        B WDT_IRQHandler
        
        PUBWEAK LVD_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LVD_IRQHandler
        B LVD_IRQHandler

        PUBWEAK RTC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RTC_IRQHandler
        B RTC_IRQHandler
        
        PUBWEAK RSV1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RSV1_IRQHandler
        B RSV1_IRQHandler

        PUBWEAK EFC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EFC_IRQHandler
        B EFC_IRQHandler

        PUBWEAK SRAM_PARITY_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SRAM_PARITY_IRQHandler
        B SRAM_PARITY_IRQHandler

        PUBWEAK CLKRDY_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CLKRDY_IRQHandler
        B CLKRDY_IRQHandler

        PUBWEAK EXTI0_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI0_IRQHandler
        B EXTI0_IRQHandler

        PUBWEAK EXTI1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI1_IRQHandler
        B EXTI1_IRQHandler

        PUBWEAK EXTI2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI2_IRQHandler
        B EXTI2_IRQHandler

        PUBWEAK EXTI3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI3_IRQHandler
        B EXTI3_IRQHandler

        PUBWEAK EXTI4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI4_IRQHandler
        B EXTI4_IRQHandler

        PUBWEAK DMA1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA1_IRQHandler
        B DMA1_IRQHandler

        PUBWEAK DMA2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DMA2_IRQHandler
        B DMA2_IRQHandler

        PUBWEAK ADC1_2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
ADC1_2_IRQHandler
        B ADC1_2_IRQHandler

        PUBWEAK RSV2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RSV2_IRQHandler
        B RSV2_IRQHandler

        PUBWEAK DAC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
DAC_IRQHandler
        B DAC_IRQHandler

        PUBWEAK COMP1_2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
COMP1_2_IRQHandler
        B COMP1_2_IRQHandler

        PUBWEAK USB_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
USB_IRQHandler
        B USB_IRQHandler

        PUBWEAK CAN1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN1_IRQHandler
        B CAN1_IRQHandler

        PUBWEAK CAN2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
CAN2_IRQHandler
        B CAN2_IRQHandler

        PUBWEAK EXTI9_5_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI9_5_IRQHandler
        B EXTI9_5_IRQHandler

        PUBWEAK TIM1_BRK_UP_TRG_COM_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM1_BRK_UP_TRG_COM_IRQHandler
        B TIM1_BRK_UP_TRG_COM_IRQHandler

        PUBWEAK TIM1_CC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM1_CC_IRQHandler
        B TIM1_CC_IRQHandler

        PUBWEAK TIM2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM2_IRQHandler
        B TIM2_IRQHandler

        PUBWEAK TIM3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM3_IRQHandler
        B TIM3_IRQHandler

        PUBWEAK TIM6_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM6_IRQHandler
        B TIM6_IRQHandler

        PUBWEAK TIM7_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM7_IRQHandler
        B TIM7_IRQHandler

        PUBWEAK TIM8_BRK_UP_TRG_COM_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM8_BRK_UP_TRG_COM_IRQHandler
        B TIM8_BRK_UP_TRG_COM_IRQHandler

        PUBWEAK TIM8_CC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM8_CC_IRQHandler
        B TIM8_CC_IRQHandler

        PUBWEAK TIM15_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM15_IRQHandler
        B TIM15_IRQHandler

        PUBWEAK TIM16_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM16_IRQHandler
        B TIM16_IRQHandler

        PUBWEAK TIM17_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM17_IRQHandler
        B TIM17_IRQHandler

        PUBWEAK I2C1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2C1_IRQHandler
        B I2C1_IRQHandler

        PUBWEAK I2C2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2C2_IRQHandler
        B I2C2_IRQHandler

        PUBWEAK SPI1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI1_IRQHandler
        B SPI1_IRQHandler

        PUBWEAK SPI2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI2_IRQHandler
        B SPI2_IRQHandler

        PUBWEAK SPI3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI3_IRQHandler
        B SPI3_IRQHandler

        PUBWEAK I2S1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2S1_IRQHandler
        B I2S1_IRQHandler

        PUBWEAK I2S2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2S2_IRQHandler
        B I2S2_IRQHandler

        PUBWEAK UART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART1_IRQHandler
        B UART1_IRQHandler

        PUBWEAK UART2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART2_IRQHandler
        B UART2_IRQHandler

        PUBWEAK UART3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART3_IRQHandler
        B UART3_IRQHandler
        
        PUBWEAK UART4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART4_IRQHandler
        B UART4_IRQHandler

        PUBWEAK EXTI15_10_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI15_10_IRQHandler
        B EXTI15_10_IRQHandler

        PUBWEAK USB_WAKEUP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
USB_WAKEUP_IRQHandler
        B USB_WAKEUP_IRQHandler
        
        PUBWEAK LPUART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LPUART1_IRQHandler
        B LPUART1_IRQHandler 
        
        PUBWEAK LPTIM1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LPTIM1_IRQHandler
        B LPTIM1_IRQHandler  

        PUBWEAK RSV3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RSV3_IRQHandler
        B RSV3_IRQHandler 
        
        PUBWEAK AES_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
AES_IRQHandler
        B AES_IRQHandler  
        
        PUBWEAK FPU_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
FPU_IRQHandler
        B FPU_IRQHandler
        
        PUBWEAK RSV4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RSV4_IRQHandler
        B RSV4_IRQHandler  
       
        PUBWEAK RSV5_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RSV5_IRQHandler
        B RSV5_IRQHandler
        
        PUBWEAK TIM4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
TIM4_IRQHandler
        B TIM4_IRQHandler
        
        PUBWEAK COMP3_4_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
COMP3_4_IRQHandler
        B COMP3_4_IRQHandler
        
        PUBWEAK IWDT_WAKEUP_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
IWDT_WAKEUP_IRQHandler
        B IWDT_WAKEUP_IRQHandler
        
        
        END
/************************ (C) COPYRIGHT Aisinochip *****END OF FILE****/
