/******************************************************************************
*@file  : main.c
*@brief : This file provides UART Demos
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"  

int main(void)
{
    HAL_Init();  
    
    SystemClock_Config();    
    
    BSP_UART_Init();    /* BSP_UART is UART2 */

    BSP_PB_Init();

    printfS("----------------------------------------------------------------------------------------\r\n");
    UART1_Init();
    
    printfS("Default UART PINs:\r\n");
    printfS("UART1 TXD:PA9 , RXD:PA10\r\n");
    printfS("UART2 TXD:PA2 , RXD:PA3 [Debug Port]\r\n");
    printfS("UART3 TXD:PB10RXD:PB11\r\n");
    printfS("UART4 TXD:PA0 , RXD:PA1\r\n");
    printfS("Modify HAL_UART_MspInit() function in user code if you select other UART PINs\r\n\r\n");
    
    printfS("All UART Instances are configured as:\r\n");
    printfS("115200, 8-N-1\r\n\r\n");
    /* 
    Select Mode: 
    TEST_UART1_LOOP, 
    TEST_UART1_IT, 
    TEST_UART1_DMA, 
    TEST_UART2, 
    TEST_UART3
    */  
    APP_Uart_Test(TEST_UART2);  

    while(1)
    {

    }
}
