
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   

WDT_HandleTypeDef WDT_Handle;

volatile uint32_t g_intFlag;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t resetTime;
    uint32_t intClrTime;
    
	BSP_LED_Init();
	
    BSP_LED_On();
    HAL_Delay(2000);
    
    g_intFlag = 0;
    
	/* ʹܣWDTλϵͳλ */
	__HAL_RCC_WDTRSTTOSYSRST_ENABLE();
    
    __HAL_RCC_WDT_CLK_ENABLE();
    
    /* λʱ䣺1000msжʱޣ50ms */
    resetTime = HAL_RCC_GetPCLK1Freq() / 128;  
    intClrTime = 50;
    
	/* WDT */
    WDT_Handle.Instance = WDT;
    WDT_Handle.Init.Prescaler   = WDT_CLOCK_PRESCALER_128;
    WDT_Handle.Init.Mode        = WDT_MODE_INTERRUPT;
    WDT_Handle.Init.Load        = resetTime;
    WDT_Handle.Init.IntClrTime  = resetTime * intClrTime / 1000;
    
    HAL_WDT_Init(&WDT_Handle);


	/* ʹж */
    
    WDT_GET_IT_ENABLE(&WDT_Handle);
    
	NVIC_ClearPendingIRQ(WDT_IRQn);
	NVIC_SetPriority(WDT_IRQn, 0x00);
	NVIC_EnableIRQ(WDT_IRQn);
    
    HAL_WDT_Refresh(&WDT_Handle);
    
    while(1)
    {
        while (g_intFlag == 0);
        
        g_intFlag = 0;
        
		printfS("feed wachdog time : %u\r\n", HAL_GetTick());
        
        BSP_LED_Toggle();
    };
}

void HAL_WDT_Callback(WDT_HandleTypeDef *hwdt)
{
	/* ιжϱ־ */
    HAL_WDT_Refresh(&WDT_Handle);
    
    g_intFlag = 1;
}
