
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   

WDT_HandleTypeDef WDT_Handle;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t resetTime;
    
	BSP_LED_Init();
	
    BSP_LED_On();
    HAL_Delay(2000);
    
	/* ʹܣWDTλϵͳλ */
	__HAL_RCC_WDTRSTTOSYSRST_ENABLE();
    
    __HAL_RCC_WDT_CLK_ENABLE();
    
    /* λʱ䣺1 */
    resetTime = HAL_RCC_GetPCLK1Freq() / 4;  
    
	/* WDT */
    WDT_Handle.Instance = WDT;
    WDT_Handle.Init.Prescaler  = WDT_CLOCK_PRESCALER_4;
    WDT_Handle.Init.Mode     = WDT_MODE_RESET;
    WDT_Handle.Init.Load     = resetTime;
    
    HAL_WDT_Init(&WDT_Handle);

    HAL_WDT_Refresh(&WDT_Handle);
    
    while(1)
    {
        /* ڸλʱ䵽ǰ50msˢWDT */
        
        HAL_Delay(950);
        
		printfS("feed wachdog time : %u\r\n", HAL_GetTick());
        
        HAL_WDT_Refresh(&WDT_Handle);
        
        BSP_LED_Toggle();
    };
}
