
/******************************************************************************
*@file  : acm32g103_core.h
*@brief : This file provides set of firmware functions to manage Leds and push-button available on ACM32G103 Core Board
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "acm32g103_coreboard.h"



#define BSP_UARTx   (UART2)
UART_HandleTypeDef BSP_UART_Handle;



/******************************************************************************
*@brief : LED init
*@param : none
*@return: none
******************************************************************************/
void BSP_LED_Init(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct;

    /* Enable the GPIO_LED Clock */
    BSP_LED_CLK_ENABLE();

    GPIO_InitStruct.Pin       = BSP_LED_PIN;
    GPIO_InitStruct.Mode      = BSP_LED_MODE;
    GPIO_InitStruct.Pull      = BSP_LED_PULL;
    GPIO_InitStruct.Drive     = BSP_LED_DRIVE;
    GPIO_InitStruct.Alternate = BSP_LED_ALTERNATE;

    HAL_GPIO_Init(BSP_LED_GPIO, &GPIO_InitStruct);

    HAL_GPIO_WritePin(BSP_LED_GPIO, BSP_LED_PIN, GPIO_PIN_SET);
}

/******************************************************************************
*@brief : LED on
*@param : none
*@return: none
******************************************************************************/
void BSP_LED_On(void)
{
    HAL_GPIO_WritePin(BSP_LED_GPIO, BSP_LED_PIN, GPIO_PIN_RESET);
}

/******************************************************************************
*@brief : LED off
*@param : none
*@return: none
******************************************************************************/
void BSP_LED_Off(void)
{
    HAL_GPIO_WritePin(BSP_LED_GPIO, BSP_LED_PIN, GPIO_PIN_SET);
}

/******************************************************************************
*@brief : LED toggle
*@param : none
*@return: none
******************************************************************************/
void BSP_LED_Toggle(void)
{
    HAL_GPIO_TogglePin(BSP_LED_GPIO, BSP_LED_PIN);
}

/******************************************************************************
*@brief : PB init
*@param : none
*@return: none
******************************************************************************/
void BSP_PB_Init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;

    BSP_PB_CLK_ENABLE();

    GPIO_InitStruct.Pin       = BSP_PB_PIN;
    GPIO_InitStruct.Mode      = BSP_PB_MODE;
    GPIO_InitStruct.Pull      = BSP_PB_PULL;
    GPIO_InitStruct.Drive     = BSP_PB_DRIVE;
    GPIO_InitStruct.Alternate = BSP_PB_ALTERNATE;

    HAL_GPIO_Init(BSP_PB_GPIO, &GPIO_InitStruct);

	HAL_EXTI_ClearPending(BSP_PB_PIN);
    NVIC_ClearPendingIRQ(BSP_PB_IRQ);
    NVIC_SetPriority(BSP_PB_IRQ, 0x00);
    NVIC_EnableIRQ(BSP_PB_IRQ);
}

/******************************************************************************
*@brief : get PB state
*@param : none
*@return: none
******************************************************************************/
uint32_t BSP_PB_GetState(void)
{
    return (HAL_GPIO_ReadPin(BSP_PB_GPIO, BSP_PB_PIN));
}

/******************************************************************************
*@brief : uart1 init
*@param : none
*@return: none
******************************************************************************/
void BSP_UART_Init(void)
{
    BSP_UART_Handle.Instance        = BSP_UARTx;
    BSP_UART_Handle.Init.BaudRate   = 115200;
    BSP_UART_Handle.Init.WordLength = UART_WORDLENGTH_8B;
    BSP_UART_Handle.Init.StopBits   = UART_STOPBITS_1;
    BSP_UART_Handle.Init.Parity     = UART_PARITY_NONE;
    BSP_UART_Handle.Init.Mode       = UART_MODE_TX_RX;
    BSP_UART_Handle.Init.HwFlowCtl  = UART_HWCONTROL_NONE;

    HAL_UART_Init(&BSP_UART_Handle);
    
    HAL_UART_SetDebugUart(BSP_UART_Handle.Instance);
     
	printfS("\r\n\r\n====== ACM32G103 MCU is runing ======\r\nSysCoreClk: %dHz, HCLK:%dHz\r\nPCLK1:%dHz, PCLK2:%dHz\r\n\r\n",(int)g_SystemCoreClock, (int)HAL_RCC_GetHCLKFreq(),(int)HAL_RCC_GetPCLK1Freq(),(int)HAL_RCC_GetPCLK2Freq());  
    
}

/******************************************************************************
*@brief : uart1 reinit
*@param : none
*@return: none
******************************************************************************/
void BSP_UART_DeInit(void)
{
    HAL_UART_DeInit(&BSP_UART_Handle);
}


/******************************************************************************
*@brief : MCO init
*@param : none
*@return: none
******************************************************************************/
void BSP_MCO_Init(void)
{
    GPIO_InitTypeDef  GPIO_InitStruct;
    RCC_MCOInitTypeDef  MCO_InitStruct = {0};

    BSP_MCO1_CLK_ENABLE();

    GPIO_InitStruct.Pin       = BSP_MCO1_PIN;
    GPIO_InitStruct.Mode      = BSP_MCO1_MODE;
    GPIO_InitStruct.Pull      = BSP_MCO1_PULL;
    GPIO_InitStruct.Drive     = BSP_MCO1_DRIVE;
    GPIO_InitStruct.Alternate = BSP_MCO1_ALTERNATE;

    HAL_GPIO_Init(BSP_MCO1_GPIO, &GPIO_InitStruct);
    
    MCO_InitStruct.Output = RCC_MCO_RC64M;
    MCO_InitStruct.MCO1 = DISABLE;
    MCO_InitStruct.MCO1Div = 0U;
    MCO_InitStruct.MCO1RevPol = DISABLE;
    MCO_InitStruct.MCO2 = DISABLE;
    MCO_InitStruct.MCO2Div = 0U;
    MCO_InitStruct.MCO2RevPol = DISABLE;
    
    HAL_RCC_MCOConfig(&MCO_InitStruct);
}

/******************************************************************************
*@brief : get reset source
*@param : none
*@return: none
******************************************************************************/
void get_reset_source(void)
{
	uint32_t reset;
	
	reset = __HAL_RCC_GET_RESETSOURCE();
    __HAL_RCC_CLEAR_RESETSOURCE();
    
	if (reset == 0)
	{
		printfS("reset sourceunknown\r\n");
        return;
	}
	if (reset & RCC_RESETSOURCE_PWR)
	{
		printfS("reset source: pwr\r\n");
	}
	if (reset & RCC_RESETSOURCE_POR12)
	{
		printfS("reset source: por12\r\n");
	}
	if (reset & RCC_RESETSOURCE_SOFT)
	{
		printfS("reset source: soft\r\n");
	}
	if (reset & RCC_RESETSOURCE_NOMAP)
	{
		printfS("reset source: nomap\r\n");
	}
	if (reset & RCC_RESETSOURCE_EFC)
	{
		printfS("reset source: efc\r\n");
	}
	if (reset & RCC_RESETSOURCE_RSTN)
	{
		printfS("reset source: rstn\r\n");
	}
	if (reset & RCC_RESETSOURCE_SYSREQ)
	{
		printfS("reset source: sysreq\r\n");
	}
	if (reset & RCC_RESETSOURCE_LOCKUP)
	{
		printfS("reset source: lockup\r\n");
	}
	if (reset & RCC_RESETSOURCE_IWDT)
	{
		printfS("reset source: iwdt\r\n");
	}
	if (reset & RCC_RESETSOURCE_WDT)
	{
		printfS("reset source: wdt\r\n");
	}
	if (reset & RCC_RESETSOURCE_LVD)
	{
		printfS("reset source: lvd\r\n");
	}
}

#ifdef USE_FULL_ASSERT
void assert_failed(uint8_t* file, uint32_t line)
{ 
	printfS("failedfile:%s, line:%u\r\n", file, (int)line);
	while (1);
}
#endif