
/******************************************************************************
*@file  : spl_comp.h
*@brief : COMP SPL module driver header file.
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#ifndef __SPL_COMP_H__
#define __SPL_COMP_H__

#include "acm32g103_spl_conf.h" 

#define COMP1        (0x00)
#define COMP2        (0x04)
#define COMP3        (0x08)
#define COMP4        (0x0c)


typedef struct
{
    uint32_t            InPSel;         //input plus select
    uint32_t            InMSel;         //input minus select
    uint32_t            Polarity;       //polarity 
    uint32_t            HYS;            //Hysteresis window
    uint32_t            BlankSel;       //blank source select
    uint32_t            WinMode;        //window mode input plus select
    uint32_t            WinOut;         //window mode output xor
    uint32_t            FltEn;          //filt enable
    uint32_t            FltTime;        //filt time
    uint32_t            CrvEn;          //reference voltage divide enable 
    uint32_t            CrvSel;         //reference voltage source select
    uint32_t            CrvCfg;         //reference voltage divider factor config 
}COMP_InitTypeDef;



#define COMP_CRVSEL_AVDD                    (0U)       
#define COMP_CRVSEL_VREF                    (COMP_CR_CRVSEL)  

#define COMP_CRV_DISABLE                    (0U)       
#define COMP_CRV_ENABLE                     (COMP_CR_CRVEN)   

#define COMP_WINMODE_SELF_INP               (0U)       
#define COMP_WINMODE_ANOTHER_INP            (COMP_CR_WINMODE)   

#define COMP_WINOUT_DIRECT                  (0U)       
#define COMP_WINOUT_XOR                     (COMP_CR_WINOUT)       
   

#define COMP_POLARITY_NOINVERT              (0U)   
#define COMP_POLARITY_INVERT                (COMP_CR_POLARITY)   

#define COMP_FLT_DISABLE                    (0U)       
#define COMP_FLT_ENABLE                     (COMP_CR_FLTEN)   

#define COMP_FLTTIME_1CLK                   (0U)   
#define COMP_FLTTIME_2CLK                   (1U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_4CLK                   (2U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_16CLK                  (3U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_64CLK                  (4U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_256CLK                 (5U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_1024CLK                (6U << COMP_CR_FLTTIME_Pos)   
#define COMP_FLTTIME_4095CLK                (7U << COMP_CR_FLTTIME_Pos)   
   
#define COMP_BLANKSEL_NONE                  (0U)
#define COMP_BLANKSEL_S1                    (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP_BLANKSEL_S2                    (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S3                    (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S4                    (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S5                    (5U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S6                    (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP_BLANKSEL_S7                    (7U << COMP_CR_BLANKSEL_Pos) 

#define COMP1_BLANKSEL_NONE                 (0U)
#define COMP1_BLANKSEL_TIM1_OC5             (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP1_BLANKSEL_TIM2_OC3             (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP1_BLANKSEL_TIM3_OC3             (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP1_BLANKSEL_TIM8_OC5             (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP1_BLANKSEL_TIM1_OC4             (5U << COMP_CR_BLANKSEL_Pos) 
#define COMP1_BLANKSEL_TIM15_OC1            (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP1_BLANKSEL_TIM4_OC3             (7U << COMP_CR_BLANKSEL_Pos) 

#define COMP2_BLANKSEL_NONE                 (0U)
#define COMP2_BLANKSEL_TIM1_OC5             (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP2_BLANKSEL_TIM2_OC3             (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP2_BLANKSEL_TIM3_OC3             (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP2_BLANKSEL_TIM8_OC5             (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP2_BLANKSEL_TIM1_OC4             (5U << COMP_CR_BLANKSEL_Pos) 
#define COMP2_BLANKSEL_TIM15_OC1            (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP2_BLANKSEL_TIM4_OC3             (7U << COMP_CR_BLANKSEL_Pos)

#define COMP3_BLANKSEL_NONE                 (0U)
#define COMP3_BLANKSEL_TIM1_OC5             (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP3_BLANKSEL_TIM3_OC3             (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP3_BLANKSEL_TIM2_OC4             (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP3_BLANKSEL_TIM8_OC5             (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP3_BLANKSEL_TIM8_OC4             (5U << COMP_CR_BLANKSEL_Pos) 
#define COMP3_BLANKSEL_TIM15_OC1            (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP3_BLANKSEL_TIM4_OC3             (7U << COMP_CR_BLANKSEL_Pos) 

#define COMP4_BLANKSEL_NONE                 (0U)
#define COMP4_BLANKSEL_TIM3_OC4             (1U << COMP_CR_BLANKSEL_Pos)   
#define COMP4_BLANKSEL_TIM8_OC5             (2U << COMP_CR_BLANKSEL_Pos) 
#define COMP4_BLANKSEL_TIM15_OC1            (3U << COMP_CR_BLANKSEL_Pos) 
#define COMP4_BLANKSEL_TIM1_OC5             (4U << COMP_CR_BLANKSEL_Pos) 
#define COMP4_BLANKSEL_TIM8_OC4             (5U << COMP_CR_BLANKSEL_Pos) 
//#define COMP4_BLANKSEL_TIM15_OC1            (6U << COMP_CR_BLANKSEL_Pos) 
#define COMP4_BLANKSEL_TIM4_OC3             (7U << COMP_CR_BLANKSEL_Pos) 

#define COMP_INPSEL_P0                      (0U)   
#define COMP_INPSEL_P1                      (1U << COMP_CR_INPSEL_Pos)
#define COMP_INPSEL_P2                      (2U << COMP_CR_INPSEL_Pos)

#define COMP_INMSEL_P0                      (0U)   
#define COMP_INMSEL_P1                      (1U << COMP_CR_INMSEL_Pos)
#define COMP_INMSEL_DACx                    (2U << COMP_CR_INMSEL_Pos)
#define COMP_INMSEL_VREF_AVDD               (3U << COMP_CR_INMSEL_Pos)

#define COMP1_INPSEL_PA1                    (0U)   
#define COMP1_INPSEL_PB1                    (1U << COMP_CR_INPSEL_Pos)   
#define COMP1_INPSEL_PB10                   (2U << COMP_CR_INPSEL_Pos)

#define COMP1_INMSEL_PA4                    (0U)   
#define COMP1_INMSEL_PA0                    (1U << COMP_CR_INMSEL_Pos)   
#define COMP1_INMSEL_DAC1                   (2U << COMP_CR_INMSEL_Pos)
#define COMP1_INMSEL_VREF_AVDD              (3U << COMP_CR_INMSEL_Pos)

#define COMP2_INPSEL_PA7                    (0U)   
#define COMP2_INPSEL_PA3                    (1U << COMP_CR_INPSEL_Pos)   
#define COMP2_INPSEL_PB11                   (2U << COMP_CR_INPSEL_Pos)

#define COMP2_INMSEL_PA5                    (0U)   
#define COMP2_INMSEL_PA2                    (1U << COMP_CR_INMSEL_Pos)   
#define COMP2_INMSEL_DAC2                   (2U << COMP_CR_INMSEL_Pos)
#define COMP2_INMSEL_VREF_AVDD              (3U << COMP_CR_INMSEL_Pos)

#define COMP3_INPSEL_PA0                    (0U)   
#define COMP3_INPSEL_PC1                    (1U << COMP_CR_INPSEL_Pos)   
#define COMP3_INPSEL_PC3                    (2U << COMP_CR_INPSEL_Pos)

#define COMP3_INMSEL_PF1                    (0U)   
#define COMP3_INMSEL_PC0                    (1U << COMP_CR_INMSEL_Pos)   
#define COMP3_INMSEL_DAC1                   (2U << COMP_CR_INMSEL_Pos)
#define COMP3_INMSEL_VREF_AVDD              (3U << COMP_CR_INMSEL_Pos)

#define COMP4_INPSEL_PB0                    (0U)   
#define COMP4_INPSEL_PE7                    (1U << COMP_CR_INPSEL_Pos)   
#define COMP4_INPSEL_PE9                   (2U << COMP_CR_INPSEL_Pos)

#define COMP4_INMSEL_PE8                    (0U)   
#define COMP4_INMSEL_PB2                    (1U << COMP_CR_INMSEL_Pos)   
#define COMP4_INMSEL_DAC1                   (2U << COMP_CR_INMSEL_Pos)
#define COMP4_INMSEL_VREF_AVDD              (3U << COMP_CR_INMSEL_Pos)
 
#define COMP_HYS_NONE                       (0U) 
#define COMP_HYS_4                       (4U << COMP_CR_HYS_Pos) 
#define COMP_HYS_5                       (5U << COMP_CR_HYS_Pos) 
#define COMP_HYS_6                       (6U << COMP_CR_HYS_Pos) 
#define COMP_HYS_7                       (7U << COMP_CR_HYS_Pos) 

/** @defgroup COMP_OutputLevel
  * @{
  */ 
/* When output polarity is not inverted, comparator output is high when
   the non-inverting input is at a higher voltage than the inverting input */
#define COMP_OutputLevel_High                   ((uint32_t)0x00000001)
/* When output polarity is not inverted, comparator output is low when
   the non-inverting input is at a lower voltage than the inverting input*/
#define COMP_OutputLevel_Low                    ((uint32_t)0x00000000)

/**
  * @}
  */ 

#define IS_COMP_COMPx(_COMPx_)              (((_COMPx_) == COMP1) || \
                                             ((_COMPx_) == COMP2) || \
                                             ((_COMPx_) == COMP3) || \
                                             ((_COMPx_) == COMP4))

#define IS_COMP_CRVCFG(_CRVCFG_)            ((_CRVCFG_) <= 15U)

#define IS_COMP_CRVSEL(_CRVSEL_)            (((_CRVSEL_) == COMP_CRVSEL_AVDD) || \
                                             ((_CRVSEL_) == COMP_CRVSEL_VREF))
                                             
#define IS_COMP_CRVEN(_CRVEN_)              (((_CRVEN_) == COMP_CRV_DISABLE) || \
                                             ((_CRVEN_) == COMP_CRV_ENABLE))
                                       
#define IS_COMP_WINMODE(_WINMODE_)          (((_WINMODE_) == COMP_WINMODE_SELF_INP) || \
                                             ((_WINMODE_) == COMP_WINMODE_ANOTHER_INP))
                                           
#define IS_COMP_WINOUT(_WINOUT_)            (((_WINOUT_) == COMP_WINOUT_DIRECT) || \
                                             ((_WINOUT_) == COMP_WINOUT_XOR))
                                           
#define IS_COMP_POLARITY(_POLARITY_)        (((_POLARITY_) == COMP_POLARITY_NOINVERT) || \
                                             ((_POLARITY_) == COMP_POLARITY_INVERT))

#define IS_COMP_FLTEN(_FLTEN_)              (((_FLTEN_) == COMP_FLT_DISABLE) || \
                                             ((_FLTEN_) == COMP_FLT_ENABLE))

#define IS_COMP_FLTTIME(_FLTTIME_)          (((_FLTTIME_) == COMP_FLTTIME_1CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_2CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_4CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_16CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_64CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_256CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_1024CLK) || \
                                             ((_FLTTIME_) == COMP_FLTTIME_4095CLK))

#define IS_COMP_BLANKSEL(_BLANKSEL_)        (((_BLANKSEL_) == COMP_BLANKSEL_NONE) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S1) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S2) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S3) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S4) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S5) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S6) || \
                                             ((_BLANKSEL_) == COMP_BLANKSEL_S7))

#define IS_COMP_INPSEL(_INPSEL_)            (((_INPSEL_) == COMP_INPSEL_P0) || \
                                             ((_INPSEL_) == COMP_INPSEL_P1) || \
                                             ((_INPSEL_) == COMP_INPSEL_P2))   

#define IS_COMP_INMSEL(_INMSEL_)            (((_INMSEL_) == COMP_INMSEL_P0) || \
                                             ((_INMSEL_) == COMP_INMSEL_P1) || \
                                             ((_INMSEL_) == COMP_INMSEL_DACx) || \
                                             ((_INMSEL_) == COMP_INMSEL_VREF_AVDD))

#define IS_COMP_HYS(_HYS_)                  (((_HYS_) == COMP_HYS_NONE) || \
                                             ((_HYS_) == COMP_HYS_4) || \
                                             ((_HYS_) == COMP_HYS_5) || \
                                             ((_HYS_) == COMP_HYS_6) || \
                                             ((_HYS_) == COMP_HYS_7))
                                             
                                             
void COMP_Init(uint32_t COMP_Selection, COMP_InitTypeDef* COMP_InitStruct);
void COMP_Cmd(uint32_t COMP_Selection, FunctionalState NewState);

#endif

