
/******************************************************************************
*@file  : spl_iwdt.h
*@brief : Header file of IWDT SPL module.
******************************************************************************/

#ifndef __SPL_IWDT_H__
#define __SPL_IWDT_H__

#include "acm32g103_spl_conf.h"



/** @defgroup IWDT_Cmd
  * @{
  */

#define IWDT_CMD_ENABLE                 ( 0xCCCCU )
#define IWDT_CMD_WRITE_ENABLE           ( 0x5555U )
#define IWDT_CMD_WRITE_DISABLE          ( 0x0000U )
#define IWDT_CMD_WAKEUP_ENABLE          ( 0x6666U )
#define IWDT_CMD_WAKEUP_DISABLE         ( 0x9999U )
#define IWDT_CMD_RELOAD                 ( 0xAAAAU )

/**
  * @}
  */
  
/** @defgroup IWDT_Clock_Prescaler
  * @{
  */

#define IWDT_CLOCK_PRESCALER_4          ( 0U )
#define IWDT_CLOCK_PRESCALER_8          ( 1U )
#define IWDT_CLOCK_PRESCALER_16         ( 2U )
#define IWDT_CLOCK_PRESCALER_32         ( 3U )
#define IWDT_CLOCK_PRESCALER_64         ( 4U )
#define IWDT_CLOCK_PRESCALER_128        ( 5U )
#define IWDT_CLOCK_PRESCALER_256        ( 6U )
#define IWDT_CLOCK_PRESCALER_256_1      ( 7U )

/**
  * @}
  */
  
/** @defgroup IWDT_Wakeup_Mode
  * @{
  */

#define  IWDT_WAKEUP_MODE_IT            ( EXTI_MODE_IT_RISING )
#define  IWDT_WAKEUP_MODE_EVENT         ( EXTI_MODE_EVT_RISING )

/**
  * @}
  */
  
/** @defgroup IWDT_Flag
  * @{
  */

#define  IWDT_FLAG_PVU                  ( IWDT_SR_PVU )
#define  IWDT_FLAG_RVU                  ( IWDT_SR_RVU )
#define  IWDT_FLAG_WVU                  ( IWDT_SR_WVU )
#define  IWDT_FLAG_WTU                  ( IWDT_SR_WTU )
#define  IWDT_FLAG_RLF                  ( IWDT_SR_RLF )

/**
  * @}
  */
  
/**
  * @brief   IWDT EXTI Line number
  */
  
#define  IWDT_EXTI_LINE                 ( EXTI_LINE_19 )

/**
  * @brief   IWDT down-counter reload max value
  */
  
#define IWDT_RELOAD_MAX_VALUE           ( 0x0FFFU )


/** @defgroup IWDT_TIMEOUT
  * @{
  */
  
#define IWDT_PVU_TIMEOUT                ( 30U )
#define IWDT_RVU_TIMEOUT                ( 30U )
#define IWDT_WVU_TIMEOUT                ( 30U )
#define IWDT_WTU_TIMEOUT                ( 30U )
#define IWDT_RLF_TIMEOUT                ( 30U )

/**
  * @}
  */
  

/** @defgroup  IWDT Private Macros
  * @{
  */
  
#define IS_IWDT_WRITE_ACCESS(__ACCESS__)        (((__ACCESS__) == IWDT_WriteAccess_Enable) || \
                                                 ((__ACCESS__) == IWDT_WriteAccess_Disable))
                                                 
#define IS_IWDT_CMD(__CMD__)                    (((__CMD__) == IWDT_CMD_ENABLE)  || \
                                                 ((__CMD__) == IWDT_CMD_DISABLE)  || \
                                                 ((__CMD__) == IWDT_CMD_WRITE_ENABLE) || \
                                                 ((__CMD__) == IWDT_CMD_WAKEUP_ENABLE) || \
                                                 ((__CMD__) == IWDT_CMD_WAKEUP_DISABLE) || \
                                                 ((__CMD__) == IWDT_CMD_RELOAD))



#define IS_IWDT_PRESCALER(__PRESCALER__)        (((__PRESCALER__) == IWDT_CLOCK_PRESCALER_4)  || \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_8)  || \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_16) || \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_32) || \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_64) || \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_128)|| \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_256)|| \
                                                 ((__PRESCALER__) == IWDT_CLOCK_PRESCALER_256_1))

#define IS_IWDT_WAKEUPMODE(__MODE__)            (((__MODE__) == IWDT_WAKEUP_MODE_IT)  || \
                                                 ((__MODE__) == IWDT_WAKEUP_MODE_EVENT))

#define IS_IWDT_RELOAD(__RELOAD__)              ((__RELOAD__) <= IWDT_RELOAD_MAX_VALUE)

#define IS_IWDT_WINDOW(__WINDOW__)              ((__WINDOW__) <= IWDT_RELOAD_MAX_VALUE)

#define IS_IWDT_WAKEUP(__WAKEUP__)              ((__WAKEUP__) <= IWDT_RELOAD_MAX_VALUE)


#define IS_IWDT_FLAGS(__FLAGS__)                (((__FLAGS__) == IWDT_FLAG_PVU)  || \
                                                 ((__FLAGS__) == IWDT_FLAG_RVU)  || \
                                                 ((__FLAGS__) == IWDT_FLAG_WVU) || \
                                                 ((__FLAGS__) == IWDT_FLAG_WTU) || \
                                                 ((__FLAGS__) == IWDT_FLAG_RLF))


/**
  * @}
  */
  
/* Exported functions --------------------------------------------------------*/

void IWDT_WriteAccessCmd(FunctionalState NewState);
void IWDT_WakeupCmd(FunctionalState NewState);
void IWDT_Enable(void);
void IWDT_ReloadCounter(void);
void IWDT_SetPrescaler(uint32_t Prescaler);
void IWDG_SetReload(uint32_t Reload);
void IWDG_SetWindow(uint32_t Window);
void IWDG_SetWakeup(uint32_t Wakeup);
void IWDT_Refresh(void);
FlagStatus IWDT_GetFlagStatus(uint32_t Flag);








#endif
