
/******************************************************************************
*@file  : spl_misc.h
*@brief : Header file of MISC SPL module.
******************************************************************************/

#ifndef __SPL_MISC_H
#define __SPL_MISC_H

#include "spl_def.h"

/** CORTEX_Preemption_Priority_Group CORTEX Preemption Priority Group  */
#define NVIC_PRIORITYGROUP_0         0x00000007U /*!< 0 bits for pre-emption priority, 4 bits for subpriority */
#define NVIC_PRIORITYGROUP_1         0x00000006U /*!< 1 bits for pre-emption priority, 3 bits for subpriority */
#define NVIC_PRIORITYGROUP_2         0x00000005U /*!< 2 bits for pre-emption priority, 2 bits for subpriority */
#define NVIC_PRIORITYGROUP_3         0x00000004U /*!< 3 bits for pre-emption priority, 1 bits for subpriority */
#define NVIC_PRIORITYGROUP_4         0x00000003U /*!< 4 bits for pre-emption priority, 0 bits for subpriority */

/** CORTEX_SysTick_clock_source CORTEX _SysTick clock source  */
#define SYSTICK_CLKSOURCE_HCLK_DIV8    0x00000000U
#define SYSTICK_CLKSOURCE_HCLK         0x00000004U

void SysTick_Inc(void);
uint32_t SysTick_Get(void);
void DelayMs(uint32_t Delay);
void SysTick_Suspend(void);
void SysTick_Resume(void);
void Delay_Simple(volatile uint32_t delay);
uint32_t EnterCritical(void);
void ExitCritical(uint32_t save_irq);

#endif
