
/******************************************************************************
*@file  : spl_opa.h
*@brief : OPA SPL module driver header file.
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#ifndef __SPL_OPA_H__
#define __SPL_OPA_H__

#include "acm32g103_spl_conf.h" 

#define OPA1        (0x01)
#define OPA2        (0x02)
#define OPA3        (0x03)

typedef struct
{
    uint32_t            OPAMP_InvertingInput;       // the opa VINP select    
    uint32_t            OPAMP_NonInvertingInput;    // the opa VinM0 enable selection and opa mode selection 
    uint32_t            OutSel;     // the opa output select     
    uint32_t            Hsm;        // the opa HSM driver mode:OPA_HSM_LOW or OPA_HSM_HIGH

}OPAMP_InitTypeDef;

#define OPA_POL_INVERT                      (0x1UL << OPA_CSR_POLSEL_Pos)

#define OPA_VINM0_ENABLE                    (OPA_CSR_VINM0EN)

#define OPA_HSM_LOW                         (0UL)
#define OPA_HSM_HIGH                        (OPA_CSR_HSM)

#define OPA_GAIN_64_63                      (0u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_32_31                      (1u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_16_15                      (2u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_8_7                        (4u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_4_3                        (8u << OPA_CSR_GAINSEL_Pos)
#define OPA_GAIN_2_1                        (16u << OPA_CSR_GAINSEL_Pos)

#define OPA_MODE_SA                         (0u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_UG                         (1u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_PGA                        (2u << OPA_CSR_MODESEL_Pos)
#define OPA_MODE_SA1                        (3u << OPA_CSR_MODESEL_Pos)

#define OPA_VINP_0                          (0u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_1                          (1u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_2                          (2u << OPA_CSR_VINPSEL_Pos)
#define OPA_VINP_3                          (3u << OPA_CSR_VINPSEL_Pos)
//P
#define OPA1_VINP_PA1                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_PA3                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_PA7                       (2u << OPA_CSR_VINPSEL_Pos)
#define OPA1_VINP_DAC1                      (3u << OPA_CSR_VINPSEL_Pos)

#define OPA2_VINP_PA7                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_PB0                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_OPA1                      (2u << OPA_CSR_VINPSEL_Pos)
#define OPA2_VINP_DAC2                      (3u << OPA_CSR_VINPSEL_Pos)

#define OPA3_VINP_PB0                       (0u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_PA1                       (1u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_PB11                      (2u << OPA_CSR_VINPSEL_Pos)
#define OPA3_VINP_DAC1                      (3u << OPA_CSR_VINPSEL_Pos)

//N
#define OPA_VINN_SA1_IO                   ((OPA_VINM0_ENABLE)|(OPA_MODE_SA1))
#define OPA_VINN_SA_IO                    ((~OPA_VINM0_ENABLE)&(OPA_MODE_SA ))
#define OPA_VINN_NOINVERT_PGA              ((~OPA_VINM0_ENABLE)&(OPA_MODE_PGA))
#define OPA_VINN_INVERT_PGA                ((~OPA_VINM0_ENABLE)&(OPA_MODE_PGA)|OPA_POL_INVERT)
#define OPA_VINN_UG                        ((~OPA_VINM0_ENABLE)&(OPA_MODE_UG))

#define OPA_OUT_GPIO                        (0u)
#define OPA_OUT_INNER                       (0x1UL << OPA_CSR_OUTSEL_Pos)

#define IS_OPA_HSM(_HSM_)                   (((_HSM_) == OPA_HSM_LOW) || \
                                             ((_HSM_) == OPA_HSM_HIGH))
                                        
#define IS_OPA_GAIN(_GAIN_)                 (((_GAIN_) == OPA_GAIN_64_63) || \
                                             ((_GAIN_) == OPA_GAIN_32_31) || \
                                             ((_GAIN_) == OPA_GAIN_16_15) || \
                                             ((_GAIN_) == OPA_GAIN_8_7) || \
                                             ((_GAIN_) == OPA_GAIN_4_3) || \
                                             ((_GAIN_) == OPA_GAIN_2_1))

                                        
#define IS_OPA_VINP(_VINP_)                 (((_VINP_) == OPA_VINP_0) || \
                                             ((_VINP_) == OPA_VINP_1) || \
                                             ((_VINP_) == OPA_VINP_2) || \
                                             ((_VINP_) == OPA_VINP_3))

#define IS_OPA_VINN(_VINN_)                 (((_VINN_) == OPA_VINN_SA1_IO) || \
                                             ((_VINN_) == OPA_VINN_SA_IO) || \
                                             ((_VINN_) == OPA_VINN_NOINVERT_PGA) || \
                                             ((_VINN_) == OPA_VINN_INVERT_PGA) || \
                                             ((_VINN_) == OPA_VINN_UG))

#define IS_OPA_OUT(_OUT_)                   (((_OUT_) == OPA_OUT_GPIO) || \
                                             ((_OUT_) == OPA_OUT_INNER))

#define OPAMP_Input_Inverting                 OPA_CSR_TRIMOSN_Pos /*!< Inverting input */
#define OPAMP_Input_NonInverting              OPA_CSR_TRIMOSP_Pos /*!< Non inverting input */

#define IS_OPAMP_INPUT(INPUT) (((INPUT) == OPAMP_Input_Inverting) || \
                               ((INPUT) == OPAMP_Input_NonInverting))
                               
#define OPAMP_Selection_OPAMP1                    ((uint32_t)0x00000000) /*!< OPAMP1 Selection */
#define OPAMP_Selection_OPAMP2                    ((uint32_t)0x00000004) /*!< OPAMP2 Selection */
#define OPAMP_Selection_OPAMP3                    ((uint32_t)0x00000008) /*!< OPAMP3 Selection */

#define IS_OPAMP_ALL_PERIPH(PERIPH) (((PERIPH) == OPAMP_Selection_OPAMP1) || \
                                     ((PERIPH) == OPAMP_Selection_OPAMP2) || \
                                     ((PERIPH) == OPAMP_Selection_OPAMP3))
                               
#define IS_OPAMP_TRIMMINGVALUE(VALUE) ((VALUE) <= 0x0000001F) /*!< Trimming value */

void OPAMP_Cmd(uint32_t OPAMP_Selection, FunctionalState NewState);
void OPAMP_DeInit(uint32_t OPAMP_Selection);
void OPAMP_Init(uint32_t OPAMP_Selection, OPAMP_InitTypeDef* OPAMP_InitStruct);
void OPAMP_LockConfig(uint32_t OPAMP_Selection);
void OPAMP_PGAConfig(uint32_t OPAMP_Selection, uint32_t OPAMP_PGAGain);
void OPAMP_StructInit(OPAMP_InitTypeDef* OPAMP_InitStruct);
void OPAMP_TrimFactory(uint32_t OPAMP_Selection);
void OPAMP_TrimSoftware(uint32_t OPAMP_Selection);

#endif





