/*
  ******************************************************************************
  * @file    spl_pmu.h
  * @version V1.0.0
  * @date    2023
  * @brief   Header file of PMU SPL module.
  ******************************************************************************
*/

#ifndef __HAL_PMU_H__
#define __HAL_PMU_H__

#include "acm32g103_spl_conf.h" 



/** @defgroup PMU STOP wakeup wait time 
  * @{
  */ 
#define IS_PMU_STOP_WAKE_WAIT(WAIT)           ((WAIT) < 0xFFF)
/**
  * @}
  */


/** @defgroup PMU LPLDO Voltage 
  * @{
  */ 
#define PMU_LPLDOVOLTAGE_0                     (0U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_1                     (1U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_2                     (2U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_3                     (3U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_1V1                   (4U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_5                     (5U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_6                     (6U << PMU_CTL0_LPLDO12_LV_Pos)
#define PMU_LPLDOVOLTAGE_7                     (7U << PMU_CTL0_LPLDO12_LV_Pos)
#define IS_PMU_LPLDO_VOLTAGE(VOLTAGE)          (((VOLTAGE) == PMU_LPLDOVOLTAGE_0) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_1)|| \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_2) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_3) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_1V1) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_5) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_6) || \
                                               ((VOLTAGE) == PMU_LPLDOVOLTAGE_7))
/**
  * @}
  */

/** @defgroup PMU MLDO Voltage 
  * @{
  */ 
#define PMU_MLDOVOLTAGE_1V2                     (0U << PMU_CTL0_MLDO12_LV_Pos)
#define PMU_MLDOVOLTAGE_1V                      (1U << PMU_CTL0_MLDO12_LV_Pos)
#define PMU_MLDOVOLTAGE_0V9                     (2U << PMU_CTL0_MLDO12_LV_Pos)
#define PMU_MLDOVOLTAGE_0V8                     (3U << PMU_CTL0_MLDO12_LV_Pos)
#define IS_PMU_MLDO_VOLTAGE(VOLTAGE)            (((VOLTAGE) == PMU_MLDOVOLTAGE_1V2) || \
                                                ((VOLTAGE) == PMU_MLDOVOLTAGE_1V)|| \
                                                ((VOLTAGE) == PMU_MLDOVOLTAGE_0V9) || \
                                                ((VOLTAGE) == PMU_MLDOVOLTAGE_0V8))
/**
  * @}
  */

/** @defgroup PMU LVD detection Voltage 
  * @{
  */ 
#define PMU_LVDVOLTAGE_1V71                     (0U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V01                     (1U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V23                     (2U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V43                     (3U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V51                     (4U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V73                     (5U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V80                     (6U << PMU_CTL1_LVD_SEL_Pos)
#define PMU_LVDVOLTAGE_2V90                     (7U << PMU_CTL1_LVD_SEL_Pos)
#define IS_PMU_LVD_VOLTAGE(VOLTAGE)             (((VOLTAGE) == PMU_LVDVOLTAGE_1V71) || ((VOLTAGE) == PMU_LVDVOLTAGE_2V01)|| \
                                                ((VOLTAGE) == PMU_LVDVOLTAGE_2V23) || ((VOLTAGE) == PMU_LVDVOLTAGE_2V43)|| \
                                                ((VOLTAGE) == PMU_LVDVOLTAGE_2V51) || ((VOLTAGE) == PMU_LVDVOLTAGE_2V73)|| \
                                                ((VOLTAGE) == PMU_LVDVOLTAGE_2V80) || ((VOLTAGE) == PMU_LVDVOLTAGE_2V90))
/**
  * @}
  */
  
  /** @defgroup LVD Filter Definitions 
  * @{
  */ 
#define PMU_LVDFILTER_1SAMPLE                   (0U << PMU_CTL1_FLT_TIME_Pos)
#define PMU_LVDFILTER_2SAMPLE                   (1U << PMU_CTL1_FLT_TIME_Pos)
#define PMU_LVDFILTER_4SAMPLE                   (2U << PMU_CTL1_FLT_TIME_Pos)                                   
#define PMU_LVDFILTER_16SAMPLE                  (3U << PMU_CTL1_FLT_TIME_Pos)
#define PMU_LVDFILTER_64SAMPLE                  (4U << PMU_CTL1_FLT_TIME_Pos) 
#define PMU_LVDFILTER_256SAMPLE                 (5U << PMU_CTL1_FLT_TIME_Pos) 
#define PMU_LVDFILTER_1024SAMPLE                (6U << PMU_CTL1_FLT_TIME_Pos)
#define PMU_LVDFILTER_4095SAMPLE                (7U << PMU_CTL1_FLT_TIME_Pos)
#define IS_PMU_LVD_FILTER(FILTER)               (((FILTER) == PMU_LVDFILTER_1SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_2SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_4SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_16SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_64SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_256SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_1024SAMPLE) || \
                                                ((FILTER) == PMU_LVDFILTER_4095SAMPLE))
/**
  * @}
  */ 
  
/** @defgroup PMU BOR detection Voltage 
  * @{
  */ 
#define PMU_BORVOLTAGE_2V_2V1                   (0U << PMU_CTL2_BOR_CFG_Pos)
#define PMU_BORVOLTAGE_2V2_2V3                  (1U << PMU_CTL2_BOR_CFG_Pos)
#define PMU_BORVOLTAGE_2V49_2V61                (2U << PMU_CTL2_BOR_CFG_Pos)
#define PMU_BORVOLTAGE_2V77_2V9                 (3U << PMU_CTL2_BOR_CFG_Pos)
#define IS_PMU_BOR_VOLTAGE(VOLTAGE)             (((VOLTAGE) == PMU_BORVOLTAGE_2V_2V1) || \
                                                ((VOLTAGE) == PMU_BORVOLTAGE_2V2_2V3)|| \
                                                ((VOLTAGE) == PMU_BORVOLTAGE_2V49_2V61) || \
                                                ((VOLTAGE) == PMU_BORVOLTAGE_2V77_2V9))
/**
  * @}
  */

/** @defgroup PMU Wake Up Pin
  * @{
  */
#define PMU_WAKEUP_PIN1                         (0x01U)
#define PMU_WAKEUP_PIN2                         (0x02U)
#define PMU_WAKEUP_PIN3                         (0x04U)
#define PMU_WAKEUP_PIN4                         (0x08U)
#define PMU_WAKEUP_PIN5                         (0x10U)                         
#define IS_PMU_WAKEUP_PIN(PIN)                  (((PIN) == PMU_WAKEUP_PIN1) || ((PIN) == PMU_WAKEUP_PIN2) || \
                                                ((PIN) == PMU_WAKEUP_PIN3) || ((PIN) == PMU_WAKEUP_PIN4) || \
                                                ((PIN) == PMU_WAKEUP_PIN5)) 
/**
  * @}
  */ 

/** @defgroup PMU Wake Up polarity
  * @{
  */
#define PMU_WAKEUPPIN_POLARITY_HIGH             (0x00U)
#define PMU_WAKEUPPIN_POLARITY_LOW              (0x01U)                      
#define IS_PMU_WAKEUP_PIN_POLARITY(POLARITY)    (((POLARITY) == PMU_WAKEUPPIN_POLARITY_HIGH) || \
                                                ((POLARITY) == PMU_WAKEUP_PIN1)) 
/**
  * @}
  */ 

/** @defgroup PMU lowpower mode entry 
  * @{
  */
#define PMU_LOWPOWRENTRY_WFI                    (0x01U)
#define PMU_LOWPOWRENTRY_WFE                    (0x02U)
#define IS_PMU_LOWPOWR_ENTRY(ENTRY)             (((ENTRY) == PMU_LOWPOWRENTRY_WFI) || \
                                                ((ENTRY) == PMU_LOWPOWRENTRY_WFE))
/**
  * @}
  */ 


/** @defgroup PMU Stop mode selection 
  * @{
  */
#define PMU_STOP_0                              (0x00U)
#define PMU_STOP_1                              (0x01U)
#define PMU_STOP_2                              (0x02U)
#define IS_PMU_STOP(MODE)                       (((MODE) == PMU_STOP_0) || ((MODE) == PMU_STOP_1) || \
                                                ((MODE) == PMU_STOP_2))
/**
  * @}
  */  

/** @defgroup PMU Wake Up Pin
  * @{
  */
#define PMU_STANDBYWAKEWAIT_1RC32K              (0x00U)
#define PMU_STANDBYWAKEWAIT_2RC32K              (0x01U)
#define PMU_STANDBYWAKEWAIT_3RC32K              (0x02U)
#define PMU_STANDBYWAKEWAIT_4RC32K              (0x03U)
#define PMU_STANDBYWAKEWAIT_5RC32K              (0x04U)  
#define PMU_STANDBYWAKEWAIT_6RC32K              (0x05U)   
#define PMU_STANDBYWAKEWAIT_7RC32K              (0x06U) 
#define PMU_STANDBYWAKEWAIT_NONE                (0x07U)                          
#define IS_PMU_STANDBY_WAKE_WAIT(WAIT)          (((WAIT) == PMU_STANDBYWAKEWAIT_1RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_2RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_3RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_4RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_5RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_6RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_7RC32K) || \
                                                ((WAIT) == PMU_STANDBYWAKEWAIT_NONE)) 
/**
  * @}
  */   

/** @defgroup PMU Flag 
  * @{
  */
#define PMU_FLAG_WUPF1                          (0x00000001U)
#define PMU_FLAG_WUPF2                          (0x00000002U)
#define PMU_FLAG_WUPF3                          (0x00000004U)
#define PMU_FLAG_WUPF4                          (0x00000008U)
#define PMU_FLAG_WUPF5                          (0x00000010U)
#define PMU_FLAG_SB                             (0x00000100U)
#define PMU_FLAG_RTC                            (0x00001000U)
#define PMU_FLAG_RST                            (0x00002000U)
#define PMU_FLAG_IWDT                           (0x00004000U)
#define PMU_FLAG_BOR                            (0x00008000U)
#define PMU_FLAG_ALL                            (0x0000FFFFU)
#define IS_PMU_FLAG(FLAG)                       (((FLAG) == PMU_FLAG_WUPF1) || ((FLAG) == PMU_FLAG_WUPF2) || \
                                                ((FLAG) == PMU_FLAG_WUPF3) || ((FLAG) == PMU_FLAG_WUPF4) || \
                                                ((FLAG) == PMU_FLAG_WUPF5) || ((FLAG) == PMU_FLAG_SB) || \
                                                ((FLAG) == PMU_FLAG_RTC) || ((FLAG) == PMU_FLAG_RST) || \
                                                ((FLAG) == PMU_FLAG_IWDT) || ((FLAG) == PMU_FLAG_BOR) || \
                                                ((FLAG) == PMU_FLAG_IWDT) || ((FLAG) == PMU_FLAG_ALL))

/**
  * @}
  */
  
/** @defgroup STANDBY domain IO  
  * @{
  */
#define PMU_PIN_PC13                            (0x00U)
#define PMU_PIN_PC14                            (0x01U)
#define PMU_PIN_PC15                            (0x02U)
#define IS_PMU_PIN(PIN)                         (((PIN) == PMU_PIN_PC13) || ((PIN) == PMU_PIN_PC14) || \
                                                ((PIN) == PMU_PIN_PC15))
/**
  * @}
  */  

/** @defgroup STANDBY domain IO function selection  
  * @{
  */
#define PMU_PIN_FUNCTION_GPIO                   (0x00U)
#define PMU_PIN_FUNCTION_OUTPUT                 (0x01U)
#define PMU_PIN_FUNCTION_2                      (0x02U)
#define PMU_PIN_FUNCTION_3                      (0x03U)
#define IS_PMU_PIN_FUNCTION(FUNCTION)           (((FUNCTION) == PMU_PIN_FUNCTION_GPIO) || ((FUNCTION) == PMU_PIN_FUNCTION_OUTPUT) || \
                                                ((FUNCTION) == PMU_PIN_FUNCTION_2) || ((FUNCTION) == PMU_PIN_FUNCTION_3))
/**
  * @}
  */ 

/** @defgroup STANDBY domain IO Pin Value 
  * @{
  */
#define PMU_PIN_VALUE_0                         (0x00U)
#define PMU_PIN_VALUE_1                         (0x01U)
#define IS_PMU_PIN_VALUE(VALUE)                 (((VALUE) == PMU_PIN_VALUE_0) || ((VALUE) == PMU_PIN_VALUE_1))
/**
  * @}
  */    
  

/* Function used to set the PMU configuration to the default reset state */ 
void PMU_DeInit(void);

/* Initialization functions */
void PMU_Init(void);

/* Backup/RTC Domain Access function */ 
void PMU_BackupAccessCmd(FunctionalState NewState);

/* LVD configuration functions */
void PMU_LVDVoltageConfig(uint32_t PMU_LVDVoltage);
void PMU_LVDCmd(FunctionalState NewState);
void PMU_LVDFilterConfig(uint32_t PMU_LVDFilter);
void PMU_LVDFilterCmd(FunctionalState NewState);
uint32_t PMU_GetLVDFilterStatus(void);

/* BOR configuration functions */
void PMU_BORVoltageConfig(uint32_t PMU_BORVoltage);
void PMU_BORCmd(FunctionalState NewState);
void PMU_BORResetCmd(FunctionalState NewState);

/* Low Power modes configuration functions */ 
void PMU_WakeUpPinCmd(uint32_t PMU_WakeUpPinx, FunctionalState NewState);
void PMU_WakeUpPinFilterCmd(uint32_t PMU_WakeUpPinx, FunctionalState NewState);
void PMU_WakeUpPinPolarityConfig(uint32_t PMU_WakeUpPinx, uint32_t PMU_WakeUpPinPolarity);
void PMU_EnterSLEEPMode(uint8_t PMU_SLEEPEntry);
void PMU_EnterSTOPMode(uint32_t PMU_STOPMode, uint8_t PMU_STOPEntry);
void PMU_STOPRC64MAutoCloseCmd(FunctionalState NewState);
void PMU_STOPRC64MDivisionCmd(FunctionalState NewState);
void PMU_SetSTOPWakeWaitTime(uint32_t PMU_STOPWaitTime);
void PMU_MLDOLowpowerCmd(FunctionalState NewState);
void PMU_MLDOVoltageConfig(uint32_t PMU_MLDOVoltage);
void PMU_LPLDOVoltageConfig(uint32_t PMU_LPLDOVoltage);
void PMU_EnterSTANDBYMode(uint8_t PMU_STANDBYEntry);
void PMU_SetSTANDBYWakeWaitTime(uint32_t PMU_STANDBYWaitTime);

/* Flags management functions */ 
FlagStatus PMU_GetFlagStatus(uint32_t PMU_FLAG);
void PMU_ClearFlag(uint32_t PMU_FLAG);

/* STANDBY Domain IO configuration functions */ 
void PMU_STANDBYDomainPinConfig(uint32_t PMU_Pin, uint32_t PMU_Func);
void PMU_SetSTANDBYDomainPinValue(uint32_t PMU_Pin, uint32_t PMU_PinValue);
uint32_t PMU_GetSTANDBYDomainPinValue(uint32_t PMU_Pin);



  


#endif/* __SPL_PMU_H__ */


/************************ (C) COPYRIGHT AISINOCHIP *****END OF FILE****/





